/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webaccess.utils;

import com.sun.webaccess.auth.AuthClass;
import com.sun.webaccess.realm.WebRealm;
import com.sun.webaccess.store.WebStore;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    static final String UTIL_REALMTYPE = "RealmType";

    static {
        System.loadLibrary("WebAccess");
    }

    public static HttpSession checkSession(HttpServletRequest req, HttpServletResponse res) {
        WebRealm webRealm;
        HttpSession session = req.getSession(true);
        String realmType = null;
        String authType = null;
        Object fileName = null;
        AuthClass authObj = (AuthClass)session.getValue("uAuth");
        if (authObj != null) {
            if (authObj.authenticate(req, res)) {
                WebRealm webRealm2 = (WebRealm)session.getValue("webRealm");
                webRealm2.putSession(session);
                return session;
            }
            return null;
        }
        realmType = (String)session.getValue("RealmType");
        if (realmType == null) {
            String[] realmTypeValues = req.getParameterValues("realm");
            if (realmTypeValues != null) {
                realmType = realmTypeValues[0];
                Cookie authCookie = new Cookie("RealmType", realmType);
                authCookie.setPath(new String("/"));
                res.addCookie(authCookie);
            } else {
                Cookie[] cookieList = req.getCookies();
                int i = 0;
                while (i < cookieList.length) {
                    if ("RealmType".equals(cookieList[i].getName())) {
                        realmType = cookieList[i].getValue();
                        break;
                    }
                    ++i;
                }
            }
            if (realmType == null) {
                session.invalidate();
                return null;
            }
            session.putValue("RealmType", (Object)realmType);
        }
        if ((webRealm = WebRealm.getRealm((String)realmType)) == null) {
            session.invalidate();
            return null;
        }
        session.putValue("webRealm", (Object)webRealm);
        WebStore webStore = (WebStore)session.getValue("uPrefs");
        if (webStore == null) {
            webStore = new WebStore();
        }
        if (webStore == null || !webStore.init(session)) {
            System.err.println("Utils.checkSession: Error: webStore.init() failed: " + webStore);
            session.invalidate();
            return null;
        }
        session.putValue("uPrefs", (Object)webStore);
        String localeName = webRealm.getValue("locale", "en");
        String countryName = webRealm.getValue("country", "us");
        String variantName = webRealm.getValue("variant");
        Locale sessionLocale = variantName == null ? new Locale(localeName, countryName) : new Locale(localeName, countryName, variantName);
        if (sessionLocale == null) {
            sessionLocale = Locale.getDefault();
        }
        session.putValue("userLocale", (Object)sessionLocale);
        session.putValue("userTimezone", (Object)TimeZone.getDefault());
        if (authObj == null) {
            authType = webRealm.getValue("authType");
            try {
                Class<?> authClass = Class.forName(authType);
                try {
                    authObj = (AuthClass)authClass.newInstance();
                    session.putValue("uAuth", (Object)authObj);
                }
                catch (InstantiationException instantiationException) {
                    session.invalidate();
                    return null;
                }
                catch (IllegalAccessException illegalAccessException) {
                    session.invalidate();
                    return null;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                session.invalidate();
                return null;
            }
        }
        if (authObj == null || !authObj.authenticate(req, res)) {
            return null;
        }
        webRealm.putSession(session);
        return session;
    }

    public static String encodeText(String text) {
        return Utils.encodeText((String)text, (boolean)false);
    }

    public static String encodeText(String text, boolean wrap) {
        StringBuffer encodedText = new StringBuffer();
        int cnt = 0;
        boolean wrapped = false;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    if (!wrapped) {
                        encodedText.append(c);
                        cnt = 0;
                        break;
                    }
                    wrapped = false;
                    --cnt;
                    break;
                }
                case '\"': {
                    encodedText.append("&quot;");
                    break;
                }
                case '<': {
                    encodedText.append("&lt;");
                    break;
                }
                case '>': {
                    encodedText.append("&gt;");
                    break;
                }
                case '&': {
                    encodedText.append("&amp;");
                    break;
                }
                case ' ': {
                    if (cnt > 81 && wrap) {
                        encodedText.append("\r\n");
                        wrapped = true;
                        cnt = 0;
                        break;
                    }
                    encodedText.append(c);
                    break;
                }
                default: {
                    encodedText.append(c);
                }
            }
            ++i;
            ++cnt;
        }
        return encodedText.toString();
    }

    public static int getGID(String username) {
        if (username == null) {
            username = "nobody";
        }
        return Utils.getXID((String)username, (String)"gid");
    }

    public static String getIncludeText(String text, HttpSession session) {
        StringBuffer encodedText = new StringBuffer();
        WebStore uPrefs = Utils.getWebStore((HttpSession)session);
        Object tmp = uPrefs.getValue("mail.prefs.indentValue");
        String s = (String)tmp;
        encodedText.append(s);
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == '\n') {
                encodedText.append(text.charAt(i));
                encodedText.append(s);
            } else {
                encodedText.append(text.charAt(i));
            }
            ++i;
        }
        return encodedText.toString();
    }

    public static Properties getProperties(String fileName) throws IOException {
        Properties prop = new Properties();
        prop.load(new BufferedInputStream(new FileInputStream(fileName)));
        return prop;
    }

    public static String getQueryString(HttpServletRequest req, char prefix) {
        return req.getQueryString() != null ? String.valueOf(prefix) + req.getQueryString() : "";
    }

    public static HttpSession getSession(HttpServletRequest req) {
        HttpSession session = req.getSession(false);
        return session;
    }

    public static int getUID(String username) {
        if (username == null) {
            username = "nobody";
        }
        return Utils.getXID((String)username, (String)"uid");
    }

    public static WebStore getWebStore(HttpSession session) {
        return (WebStore)session.getValue("uPrefs");
    }

    private static native int getXID(String var0, String var1);

    public static String htmlBegin(String bodyAttrs) {
        return "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">\n<HTML>\n<BODY " + (bodyAttrs != null ? bodyAttrs : "") + ">\n";
    }

    public static String htmlBegin(String title, String header, String bodyAttrs) {
        return "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">\n<HTML>\n<HEAD>\n" + (header != null ? header : "") + "<TITLE>" + title + "</TITLE>\n</HEAD>\n" + "<BODY " + (bodyAttrs != null ? bodyAttrs : "") + ">\n";
    }

    public static String htmlEnd() {
        return "</BODY>\n</HTML>";
    }

    public static String invalidSession() {
        return String.valueOf(Utils.htmlBegin((String)"BGCOLOR=WHITE")) + "Session has timed out, or you havn't logged in. Please re-log in" + Utils.htmlEnd();
    }

    public static String spacePad(String text, int len, boolean prefix) {
        int i = len - text.length();
        if (i < 0) {
            return text.substring(0, len);
        }
        StringBuffer sb = new StringBuffer(text);
        if (prefix) {
            int j = 0;
            while (j < i) {
                sb.insert(0, " ");
                ++j;
            }
        } else {
            int j = 0;
            while (j < i) {
                sb.append(" ");
                ++j;
            }
        }
        return sb.toString();
    }

    public static String[] split(char splitChar, String str) {
        if (str != null) {
            int cnt = 1;
            int i = 0;
            while (i < str.length()) {
                if (str.charAt(i) == splitChar) {
                    ++cnt;
                }
                ++i;
            }
            String[] r = new String[cnt];
            if (cnt > 1) {
                StringTokenizer t = new StringTokenizer(str, String.valueOf(splitChar));
                cnt = 0;
                while (t.hasMoreTokens()) {
                    r[cnt] = t.nextToken().trim();
                    ++cnt;
                }
            } else {
                r[0] = str.trim();
            }
            return r;
        }
        return null;
    }

    public static String system(String command) {
        StringBuffer lines = new StringBuffer();
        try {
            String line;
            Process child = Runtime.getRuntime().exec(command);
            BufferedReader in = new BufferedReader(new InputStreamReader(child.getInputStream()));
            while ((line = in.readLine()) != null) {
                lines.append(line);
            }
            in.close();
            try {
                child.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lines.toString();
    }

    public static String translate(String text, String from, String to) {
        StringBuffer tmp = new StringBuffer();
        int i = 0;
        int j = 0;
        try {
            while ((j = text.indexOf(from, i)) != -1) {
                tmp.append(text.substring(i, j));
                tmp.append(to);
                i = j + from.length();
            }
            tmp.append(text.substring(i, text.length()));
        }
        catch (Exception exception) {}
        return tmp.toString();
    }

    public static String verifyParameter(String option, char prefix) {
        return option != null ? String.valueOf(prefix) + option : "";
    }

    public static String zeroPad(int i, int numDigits) {
        StringBuffer sb = new StringBuffer();
        sb.append(i);
        int j = numDigits - sb.length();
        if (j > 0) {
            i = 0;
            while (i < j) {
                sb.insert(0, 0);
                ++i;
            }
        }
        return sb.toString();
    }
}

