#include "lber.h"
#include "ldap.h"
#include "impopauth.h"
#include <strings.h>

#define UID_ATTR        "uid"
#define CRYPTED_ATTR  "userPassword"
#define MAILHOST_ATTR "mailHost"
#define USERAUTHSERVICE "inetAuthorizedServices"
#define USERSTATUS      "inetSubscriberStatus"
#define ADMIN_ATTR      "inetAdministeredServices"

#include <unistd.h>
#include <pthread.h>
#include <sys/time.h>
#include <syslog.h>

void get_ldap_attributes(struct auth_user_info *,
                         LDAP *, LDAPMessage *);

int ims_utils_init(int utilv, void *utilptr){
}

char * ims_apop_get_challenge (char * mailhost)
{
 char challenge[1024];
 struct timeval tp;

 gettimeofday(&tp, NULL);
 sprintf(challenge, "<%d.%d.%d@%s>", pthread_self(), 
         getpid(), tp.tv_sec, mailhost);
 return(strdup(challenge));
}


int ims_apop_authenticate
        (const char *user, const char *challenge, const char *response,
         struct auth_user_info *userinfo)
{
/*The following 4 variables are hardcoded here for the sake of this sample
  implementation. They need to be changed for your specific
  implemenattion.*/
 char * admin_dn =
       "cn=Site Administrator,ou=People,dc=eng,dc=sun,dc=com,o=internet";
 char * admin_pw = "secret";
 char * base_dn = "dc=eng,dc=sun,dc=com,o=internet";
 char *ldap_server = "pyroxene.eng.sun.com";
 LDAP *ld;
 char filter[512] ;
 char  *attr[] = { ADMIN_ATTR, MAILHOST_ATTR, USERAUTHSERVICE, 
                   USERSTATUS, CRYPTED_ATTR, 0 };


 LDAPMessage *result, *entry;
 char  **vals, *passwd, *strdigest;
 unsigned char *digest;
 char input[1024];
 int res;

 if ( (ld = ldap_open(ldap_server, LDAP_PORT)) == NULL ) {
   syslog( LOG_ERR,"ldap_open on server %s failed" , ldap_server);
   return 0;
 }

 if  (ldap_simple_bind_s(ld, admin_dn, admin_pw) != LDAP_SUCCESS){
   ldap_perror( ld,"bind");
   ldap_unbind(ld);
   return 0;
 }
 sprintf(filter, "(%s=%s)", UID_ATTR, user);
 if ( ldap_search_s(ld, base_dn, LDAP_SCOPE_SUBTREE,
                        filter, attr, 0, &result) != LDAP_SUCCESS){
   ldap_perror( ld, "ldap_search_s" );
   ldap_unbind(ld);
   return 0;
 }

 if ( ldap_count_entries( ld, result ) != 1) {
   ldap_perror(ld, "ldap_count_entries");
   ldap_unbind(ld);
   return 0;
 }

 entry = ldap_first_entry(ld, result);
 vals = ldap_get_values(ld, entry, CRYPTED_ATTR);
 if (vals && vals[0] && *vals[0]){
   userinfo -> passwd = strdup(vals[0]);
 }

 /*get the digest for challenge"password" and compare to response.*/
 strcpy(input, challenge);
 strcat(input, userinfo -> passwd);
 digest = ims_give_md5digest(input);
 strdigest = ims_get_md5string((unsigned char *)digest);
 res = strcmp(strdigest, response);
 if (res != 0){/*If unauthorized, no need to do any more work.*/
   if (digest) free(digest); 
   if (strdigest) free(strdigest); 
   if (vals) ldap_value_free(vals);
   ldap_unbind(ld);
   return 0;
 }
 /* Get all the ldap attributes needed and store
   them in the userinfo structure. */
 get_ldap_attributes(userinfo, ld, entry);

 /*Some customers may need to put real uid in there. */
 userinfo -> uid = strdup(user);
 if (vals) ldap_value_free(vals);
 ldap_unbind(ld);
 if (digest) free(digest); 
 if (strdigest) free(strdigest); 
 return 1;
}


/*The following is a sample implementation for standard user
  authentication with ldap. In the absence of this routine
  imaccessd uses its own default simple_authenticate, which is
  much more efficient. For that reason this code is commented out. 
  
  Since with a NULL passwd ldap_bind will succeed as
  anonymous bind we need to explicitly disallow it.

int
        ims_simple_authenticate (const char *user,const  char *passwd,
                             struct auth_user_info *userinfo)

{
 char * admin_dn =
       "cn=Site Administrator,ou=People,dc=eng,dc=sun,dc=com,o=internet";
 char * admin_pw = "secret";
 char * base_dn = "dc=eng,dc=sun,dc=com,o=internet";
 char *ldap_server = "pyroxene.eng.sun.com";
 LDAP *ld;
 char filter[512] ;
 char  *attr[] = { ADMIN_ATTR, MAILHOST_ATTR, USERAUTHSERVICE, 
                   USERSTATUS, CRYPTED_ATTR, 0 };
 LDAPMessage *result, *entry;
 char  **vals;
 char input[1024];
 int res;

 if (strcmp(passwd, "") == 0) return 0;

 if ( (ld = ldap_open(ldap_server, LDAP_PORT)) == NULL ) {
   syslog( LOG_ERR,"ldap_open on server %s failed" , ldap_server);
   return 0;
 }

 if  (ldap_simple_bind_s(ld, admin_dn, admin_pw) != LDAP_SUCCESS){
   ldap_perror( ld,"bind");
   ldap_unbind(ld);
   return 0;
 }
 sprintf(filter, "(%s=%s)", UID_ATTR, user);
 if ( ldap_search_s(ld, base_dn, LDAP_SCOPE_SUBTREE,
                        filter, attr, 0, &result) != LDAP_SUCCESS){
   ldap_perror( ld, "ldap_search_s" );
   ldap_unbind(ld);
   return 0;
 }

 if ( ldap_count_entries( ld, result ) != 1) {
   ldap_perror(ld, "ldap_count_entries");
   ldap_unbind(ld);
   return 0;
 }

 entry = ldap_first_entry(ld, result);
 vals = ldap_get_values(ld, entry, CRYPTED_ATTR);
 if (vals && vals[0] && *vals[0]){
   userinfo -> passwd = strdup(vals[0]);
 }

 res = strcmp(passwd, userinfo->passwd);
 if (res != 0) {
   if (vals) ldap_value_free(vals);
   ldap_unbind(ld);
   return 0;
 }
 get_ldap_attributes(userinfo, ld, entry);
 userinfo -> uid = strdup(user);
 if (vals) ldap_value_free(vals);
 ldap_unbind(ld);
 return 1;
}
*/

/* Get all the ldap attributes that are needed and store
   them in the userinfo structure. */

void get_ldap_attributes(struct auth_user_info *userinfo,
                         LDAP *ld, LDAPMessage *entry){

  char **vals;

  vals = ldap_get_values(ld, entry, MAILHOST_ATTR);
  if (vals && vals[0] && *vals[0]){
    userinfo -> mailhost = strdup(vals[0]);
  }
  else
    userinfo -> mailhost = NULL;
  if (vals) ldap_value_free(vals);

  vals = ldap_get_values(ld, entry, ADMIN_ATTR);
  if (vals && vals[0]) {
    int i, j;
    for (i = 0; vals[i]; i++);  /* count entries */
    userinfo -> admin_attr = (char **) malloc(sizeof (char *) * (i+1));
    for (j=0; j < i; j++){
      userinfo -> admin_attr[j] = strdup(vals[j]);
    }
    userinfo -> admin_attr[i] = NULL;
  }
  else
    userinfo -> admin_attr = NULL;

  if (vals) ldap_value_free(vals);

  vals = ldap_get_values(ld, entry, USERSTATUS);
  if (vals && vals[0] && *vals[0]){
    userinfo -> userstatus = strdup(vals[0]);
  }
  else
    userinfo -> userstatus = NULL;
  if (vals) ldap_value_free(vals);

  vals = ldap_get_values(ld, entry, USERAUTHSERVICE);
  if (vals && vals[0]) {
    int i, j;
    for (i = 0; vals[i]; i++);  /* count entries */
    userinfo -> user_authsrvc =
                        (char **) malloc(sizeof (char *) * (i+1));
    for (j=0; j < i; j++){
      userinfo -> user_authsrvc[j] = strdup(vals[j]);
    }
    userinfo -> user_authsrvc[i] = NULL;
  }
  else
    userinfo -> user_authsrvc = NULL;
  if (vals) ldap_value_free(vals);
}


