#
#ident  "@(#) SENA.tcl        1.7     97/09/12 SMI"
#
# SENA disk box rules run from 5000 to 5099 (inclusive) max
#
# Note: in general, try to use RED alerts for fatal errors and YELLOW
# ones for errors where we can continue to run. But this is more difficult
# in cases like the Fan Trays, where the box can run with just one.  In this
# case it should be a YELLOW if one fan tray dies and RED if they both do.
# But this gets much more complicated so we'll just use RED in cases like
# this for now.
#

set sena_rules {
    {
	COMMENTS {
	    for failure of a backplane node
	}
	RULE 5010
	MULTI {
	    expr { [ hotlist system.sena.*.disk_backplane.status "" ] }
	}
	{
	    set hpustatus [ findstatus $node ]
	    expr { ("$value" == "critical") && ("$hpustatus" == "alive") }
	}
	ON_OPEN {
	    set mess "$r5010mess"
	    alarm RED $node "$mess" ""
	    set imsg [ format "$ir5010msg" "$target" ]
	    snmp "$imsg"
	}
	ON_CLOSE { end_alarm }
	SEVERITY 2
	PRIORITY 2
    }
    {
	COMMENTS {
	    for interconnect node eprom failure
	}
	RULE 5011
	MULTI {
	    expr { [ hotlist system.sena.interconnect.eprom_failure "" ] }
	}
	{
	    set hpustatus [ findstatus $node ]
	    expr { ("$value" == "true") && ("$hpustatus" == "alive") }
	}
	ON_OPEN {
	    set mess "$r5011mess"
	    alarm YELLOW $node "$mess" ""
	    set imsg [ format "$ir5011msg" "$target" ]
	    snmp "$imsg"
	}
	ON_CLOSE { end_alarm }
	SEVERITY 2
	PRIORITY 2
    }
    {
	COMMENTS {
	    for front slot/disk temperature problems
	}
	RULE 5012
	MULTI {
	    expr { [ hotlist system.sena.front.front_slot.temperature_status .temperature_status ] }
	}
	{
	    set hpustatus [ findstatus $node ]
	    expr { ("$value" != "OK") && ("$hpustatus" == "alive") }
	}
	ON_OPEN {
	    set slotno [ findvalue $node.slot-num ]
	    set mess [ format "$r5012mess" $slotno $value ]
	    if { ("$value" == "Overtemp Warning") ||
	    	("$value" == "Undertemp Warning") } {
		alarm YELLOW $node "$mess" ""
	    } else {
		alarm RED $node "$mess" ""
	    }
	    set imsg [ format "$ir5012msg" "$target" "$slotno $value ]
	    snmp "$imsg"
	}
	ON_CLOSE { end_alarm }
	SEVERITY 2
	PRIORITY 2
    }
    {
	COMMENTS {
	    for rear slot/disk temperature problems
	}
	RULE 5013
	MULTI {
	    expr { [ hotlist system.sena.rear.rear_slot.temperature_status .temperature_status ] }
	}
	{
	    set hpustatus [ findstatus $node ]
	    expr { ("$value" != "OK") && ("$hpustatus" == "alive") }
	}
	ON_OPEN {
	    set slotno [ findvalue $node.slot-num ]
	    set mess [ format "$r5013mess" "$slotno" "$value" ]
	    if { ("$value" == "Overtemp Warning") ||
	    	("$value" == "Undertemp Warning") } {
		alarm YELLOW $node "$mess" ""
	    } else {
		alarm RED $node "$mess" ""
	    }
	    set imsg [ format "$ir5013msg" "$target" $slotno $value ]
	    snmp "$imsg"
	}
	ON_CLOSE { end_alarm }
	SEVERITY 2
	PRIORITY 2
    }
    {
	COMMENTS {
	    for front disk faults (requested or detected)
	}
	RULE 5020
	MULTI {
	    expr { [ hotlist system.sena.front.front_slot.loop_status .loop_status ] }
	}
	{
	    set hpustatus [ findstatus $node ]
	    expr { ("$value" == "faulted") && ("$hpustatus" == "alive") }
	}
	ON_OPEN {
	    set slotno [ findvalue $node.slot-num ]
	    set mess [ format "$r5020mess" "$slotno" ]
	    alarm RED $node.loop_status "$mess" ""
	    set imsg [ format "$ir5020msg" "$target" "$slotno" ]
	    snmp "$imsg"
	}
	ON_CLOSE { end_alarm }
	SEVERITY 2
	PRIORITY 2
    }
    {
	COMMENTS {
	    for rear disk faults (requested or detected)
	}
	RULE 5021
	MULTI {
	    expr { [ hotlist system.sena.rear.rear_slot.loop_status .loop_status ] }
	}
	{
	    set hpustatus [ findstatus $node ]
	    expr { ("$value" == "faulted") && ("$hpustatus" == "alive") }
	}
	ON_OPEN {
	    set slotno [ findvalue $node.slot-num ]
	    set mess [ format "$r5021mess" "$slotno" ]
	    alarm RED $node "$mess" ""
	    set imsg [ format "$ir5021msg" "$target" "$slotno" ]
	    snmp "$imsg"
	}
	ON_CLOSE { end_alarm }
	SEVERITY 2
	PRIORITY 2
    }
    {
	COMMENTS {
	    for GBIC node xmitter problems
	}
	RULE 5030
	MULTI {
	    expr { [ hotlist system.sena.rear.ib.gbic.xmit_fail ".xmit_fail" ] }
	}
	{
	    set hpustatus [ findstatus $node ]
	    expr { ("$value" == "true") && ("$hpustatus" == "alive") }
	}
	ON_OPEN {
	    set mess "$r5030mess"
	    alarm RED $node "$mess" ""
	    set imsg [ format "$ir5030msg" "$target" ]
	    snmp "$imsg"
	}
	ON_CLOSE { end_alarm }
	SEVERITY 2
	PRIORITY 2
    }
    {
	COMMENTS {
	    for IB node temp. problems
	}
	RULE 5035
	MULTI {
	    expr { [ hotlist system.sena.rear.ib.temperature_status ".temperature_status" ] }
	}
	{
	    set hpustatus [ findstatus $node ]
	    expr { ("$value" != "OK") && ("$hpustatus" == "alive") }
	}
	ON_OPEN {
	    set mess [ format "$r5035mess" "$value" ]
	    alarm RED $node "$mess" ""
	    set imsg [ format "$ir5035msg" "$target" "$value" ]
	    snmp "$imsg"
	}
	ON_CLOSE { end_alarm }
	SEVERITY 2
	PRIORITY 2
    }
    {
	COMMENTS {
	    for IB node Loop 0 Fault problems
	}
	RULE 5037
	MULTI {
	    expr { [ hotlist system.sena.rear.ib.loop0_fault ".loop0_fault" ] }
	}
	{
	    set hpustatus [ findstatus $node ]
	    expr { ("$value" == "true") && ("$hpustatus" == "alive") }
	}
	ON_OPEN {
	    set mess "$r5037mess"
	    alarm RED $node "$mess" ""
	    set imsg [ format "$ir5037msg" "$target" ]
	    snmp "$imsg"
	}
	ON_CLOSE { end_alarm }
	SEVERITY 2
	PRIORITY 2
    }
    {
	COMMENTS {
	    for IB node Loop 1 Fault problems
	}
	RULE 5038
	MULTI {
	    expr { [ hotlist system.sena.rear.ib.loop1_fault ".loop1_fault" ] }
	}
	{
	    set hpustatus [ findstatus $node ]
	    expr { ("$value" == "true") && ("$hpustatus" == "alive") }
	}
	ON_OPEN {
	    set mess "$r5038mess"
	    alarm RED $node "$mess" ""
	    set imsg [ format "$ir5038msg" "$target" ]
	    snmp "$imsg"
	}
	ON_CLOSE { end_alarm }
	SEVERITY 2
	PRIORITY 2
    }
    {
	COMMENTS {
	    for pwr supply overtemp. problems
	}
	RULE 5040
	MULTI {
	    expr { [ hotlist system.sena.*.sena_power_supply.temperature_status ".temperature_status" ] }
	}
	{
	    set hpustatus [ findstatus $node ]
	    expr { ("$value" != "OK") && ("$hpustatus" == "alive") }
	}
	ON_OPEN {
	    set mess [ format "$r5040mess" "$value" ]
	    if { ( "$value" == "Overtemp Warning") } {
		alarm YELLOW $node "$mess" ""
	    } else {
		alarm RED $node "$mess" ""
	    }
	    set imsg [ format "$ir5040msg" "$target" "$value" ]
	    snmp "$imsg"
	}
	ON_CLOSE { end_alarm }
	SEVERITY 2
	PRIORITY 2
    }
    {
	COMMENTS {
	    for pwr supply DC voltage problems
	}
	RULE 5045
	MULTI {
	    expr { [ hotlist system.sena.*.sena_power_supply.DC-voltage ".DC-voltage" ] }
	}
	{
	    set hpustatus [ findstatus $node ]
	    expr { ("$value" != "OK") && ("$hpustatus" == "alive") }
	}
	ON_OPEN {
	    set mess [ format "$r5045mess" "$value" ]
	    alarm RED $node "$mess" ""
	    set imsg [ format "$ir5045msg" "$target" "$value" ]
	    snmp "$imsg"
	}
	ON_CLOSE { end_alarm }
	SEVERITY 2
	PRIORITY 2
    }
    {
	COMMENTS {
	    for pwr supply DC current problems
	}
	RULE 5047
	MULTI {
	    expr { [ hotlist system.sena.*.sena_power_supply.DC-current ".DC-current" ] }
	}
	{
	    set hpustatus [ findstatus $node ]
	    expr { ("$value" != "OK") && ("$hpustatus" == "alive") }
	}
	ON_OPEN {
	    set mess [ format "$r5047mess" "$value" ]
	    alarm RED $node "$mess" ""
	    set imsg [ format "$ir5047msg" "$target" "$value" ]
	    snmp "$imsg"
	}
	ON_CLOSE { end_alarm }
	SEVERITY 2
	PRIORITY 2
    }
    {
	COMMENTS {
	    for pwr supply AC problems
	}
	RULE 5049
	MULTI {
	    expr { [ hotlist system.sena.*.sena_power_supply.AC_status ".AC_status" ] }
	}
	{
	    set hpustatus [ findstatus $node ]
	    expr { ("$value" != "OK") && ("$hpustatus" == "alive") }
	}
	ON_OPEN {
	    set mess "$r5049mess"
	    alarm RED $node "$mess" ""
	    set imsg [ format "$ir5049msg" "$target" ]
	    snmp "$imsg"
	}
	ON_CLOSE { end_alarm }
	SEVERITY 2
	PRIORITY 2
    }
    {
	COMMENTS {
	    for fan tray node problems
	}
	RULE 5060
	MULTI {
	    expr { [ hotlist system.sena.*.fan_tray.fan_fail .fan_fail ] }
	}
	{
	    set hpustatus [ findstatus $node ]
	    expr { ("$value" == "true") && ("$hpustatus" == "alive") }
	}
	ON_OPEN {
	    set mess "$r5060mess"
	    alarm RED $node "$mess" ""
	    set imsg [ format "$ir5060msg" "$target" ]
	    snmp "$imsg"
	}
	ON_CLOSE { end_alarm }
	SEVERITY 2
	PRIORITY 2
    }
}
