// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)SimpleClient.java 3.3 99/03/12 SMI"

import java.net.* ;
import java.util.* ;
import com.sun.jaw.reference.common.* ;
import com.sun.jaw.impl.adaptor.rmi.* ;

public class SimpleClient {

    public static void main(String argv[]) {
	
        try {
            String agentHost = InetAddress.getLocalHost().getHostName() ;
            if (argv.length >= 1) 
                agentHost = argv[0] ;
      
            System.out.println(">>> Connecting to " + agentHost + "...") ;

            // Set up the RMI AdaptorClient. 
            //
            AdaptorClient adaptor = new AdaptorClient() ;

            // Initialize communication with the remote RMI managed object server.
            //
            adaptor.connect(null, agentHost, 1099, ServiceName.APT_RMI) ;

            // Create an instance of the SimpleBean m-bean in the 
            // remote object server. 
            //
            String simpleClass = "SimpleBean" ;
            ObjectName simpleName = new ObjectName("defaultDomain:SimpleBean.id=1") ;
            SimpleBeanMO simple = (SimpleBeanMO)adaptor.cb_newMO(simpleClass, simpleName, null) ;
      
            // Access and modify the properties of the SimpleBean m-bean remotely.
            //
            System.out.println("\nsimple.state     = " + simple.getState()) ;
            System.out.println("simple.nbChanges = " + simple.getNbChanges()) ;

            System.out.println("\n>>> Changing state...") ;
            simple.setState("New state") ;

            System.out.println("simple.state     = " + simple.getState()) ;
            System.out.println("simple.nbChanges = " + simple.getNbChanges()) ;

            System.out.println("\n>>> Resetting change counters...") ;
            simple.performReset() ;
      
            System.out.println("simple.state     = " + simple.getState()) ;
            System.out.println("simple.nbChanges = " + simple.getNbChanges()) ;

            // Terminates the communication with the remote managed object server.
            //
            adaptor.disconnect() ;
            System.exit(0) ;
        }
        catch(Exception e) {
            System.out.println("Got an exception !") ;
            e.printStackTrace() ;
            System.exit(1) ;
        }
    }
}
