// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)SimpleAgent.java 3.3 99/03/12 SMI"

import com.sun.jaw.reference.common.* ;
import com.sun.jaw.reference.agent.cmf.* ;
import com.sun.jaw.reference.agent.services.*;
import com.sun.jaw.impl.agent.services.light.* ;

public class SimpleAgent {

    public static void main(String argv[]) {
        try {
            String domain = "defaultDomain" ;

            // Set up the Framework.
            Framework cmf = new Framework() ;

            // Set up the Metadata service.
            String mtdSrvClass = "com.sun.jaw.impl.agent.services.light.MetaDataSrv" ;
            String mtdSrvName = domain + ":" + ServiceName.META ;
            cmf.newObject(mtdSrvClass, mtdSrvName, null) ;

            // Set up the RMI Adaptor.
            String rmiSrvClass = "com.sun.jaw.impl.adaptor.rmi.AdaptorServerImpl" ;
            String rmiSrvName = domain + ":" + ServiceName.ADAPTOR + ".protocol=rmi" ;
            cmf.newObject(rmiSrvClass, rmiSrvName, null) ;

            // Set up the HTTP Adaptor.
            String httpSrvClass = "com.sun.jaw.impl.adaptor.http.AdaptorServerImpl" ;
            String httpSrvName = domain + ":" + ServiceName.ADAPTOR + ".protocol=http" ;
            cmf.newObject(httpSrvClass, httpSrvName, null) ;
	  
        }
        catch(Exception e) {
            System.out.println("Got an exception !") ;
            e.printStackTrace() ;
            System.exit(1) ;
        }
    }
}
