// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// @(#)Agent.java 1.2 99/03/12 

// jaw import
//
import com.sun.jaw.reference.common.ObjectName;
import com.sun.jaw.reference.common.ServiceName;
import com.sun.jaw.impl.adaptor.generic.AdaptorServer;
import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.reference.agent.services.ThreadAllocatorSrvIf;


public class Agent {

    /**
     * The main method allows you to provide a command-line
     * parameter that specifies the Java DMK property file to be loaded.
     * If no property file is specified then default values will be used.
     * In addition, it allows you to specify the trace level by using the
     * DEBUG properties. For more information on trace levels,
     * refer to the class Debug.
     */
    
    private static void trace(String msg){
        System.out.println(msg);
    }
    
    public static void main(String args[]) {
        Framework            cmf;
        ThreadAllocatorSrvIf thral;
        String               domain;

        try {
            
            //
            // Instantiate the Framework
            //
            cmf    = new Framework();
            
            domain = cmf.getDomain();
            trace("Got domain = " + domain);            
            
            cmf.newObject("com.sun.jaw.impl.agent.services.light.MetaDataSrv",
                          domain + ":" + ServiceName.META, null);

            // 
            // Instantiate the thread allocator service and registers it the Framework
            //
            thral  = (ThreadAllocatorSrvIf)(Class.forName("ThreadMgtByThreadGroup").newInstance());
            cmf.setThreadAllocatorSrvIf(thral);
            
            // 
            // Add the thread allocator to the m-bean list
            //
            cmf.addObject(thral, new ObjectName("Thread_Management:ThreadMgtByThreadGroup"));
            
            //
            // Add the adaptors service.
            //
            String[] protocols = { "http" , "html" , "rmi" };
            int   [] ports     = {  8081 ,   8082 ,  1099  };
            int size = protocols.length;
            AdaptorServer[] adpList = new AdaptorServer[protocols.length];
            
            String adapClass;
            String adapName;
            
            for ( int i = 0 ; i < size  ; i++ ) {
                adapClass = new String ("com.sun.jaw.impl.adaptor." + protocols[i] + ".AdaptorServerImpl");
                adapName = new String(domain + ":" + ServiceName.ADAPTOR + ".protocol=" + protocols[i] + ",port=" + ports[i]);
                trace("Adding " + adapClass + " to CMF with name \n\t" + adapName);
                adpList[i] = (AdaptorServer) cmf.newObject(adapClass, adapName, null);
            }

            //
            // Wait for ONFILE state
            //
            
            long timeOut = 5000;
            int state = AdaptorServer.ONLINE;
            for ( int i = 0 ; i < size  ; i++ ) {
                boolean onLine = adpList[i].performWaitState(state, timeOut);
                if ( ! onLine ) {
                    System.err.println("Adaptor " + protocols[i] + " is OFFLINE. Please check port: " + ports[i] + ", it may be busy." );
                } 
            }
            
            
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
