// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)SystemImpl.java 1.4 99/03/12 SMI"

// java imports
//
import java.net.*;

// jaw imports.
//
import com.sun.jaw.snmp.agent.*;
import com.sun.jaw.snmp.common.*;


/**
 * The class is a real implementation of the "System" group defined in the ""RFC1213-MIB". 
 */

public class SystemImpl extends System {

    private long startUpTime= 0;

    public SystemImpl(SnmpMib myMib) {
    
        super(myMib);

        // Initialize the system description using some system properties.
        //
        try {
            SysDescr= java.lang.System.getProperty("os.name") + " " +
                java.lang.System.getProperty("os.arch") + " " +
                java.lang.System.getProperty("os.version");
        } catch(SecurityException e) {
        }
    
        // Initialize the SysObjectID.
        //
        SysObjectID= new String("1.3.6.1.2.1.1");

        // Initialize the system name using the hostname.
        //
        try {
            SysName= (InetAddress.getLocalHost()).getHostName();
        } catch(UnknownHostException e) {
        }
    
        // Initialize the system contact using some system properties.
        //
        try {
            SysContact= java.lang.System.getProperty("user.name");
        } catch(SecurityException e) {
        }
    
        // Initialize the set of services. Assume the agent only deals with application layer.
        //
        SysServices= new Integer(72);

        // Initialize the system location using some system properties.
        //
        try {
            SysLocation= java.lang.System.getProperty("user.name") + " office";
        } catch(SecurityException e) {
        }
    
        // For the sysUpTime, use the time the agent started.
        //
        startUpTime= java.lang.System.currentTimeMillis();
    
    }

    public Long getSysUpTime() throws SnmpStatusException {
    
        long diff= java.lang.System.currentTimeMillis() - startUpTime;
        return new Long(diff);
    }
}
