// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)StandAloneAgent.java 1.3 99/03/12 SMI"

// jaw imports.
//
import	com.sun.jaw.reference.common.*;
import	com.sun.jaw.impl.adaptor.snmp.*;
import	com.sun.jaw.snmp.agent.*;


/**
 * The StandAloneAgent class provides a standalone SNMP agent.
 * A subset of MIB II (RFC1213) is loaded and initialized.
 * 
 * The default port number of the SNMP adaptor is 8086. As such, you do not need to be root to start the agent.
 * However, this default value can be changed by specifying a port number in the command-line. 
 * For instance, if you want to use port 44450, start the agent as follows:
 *      java StandAloneAgent 44450
 */

public class StandAloneAgent {

    /**
     * The main method allows you to specify the following optional command-line parameters:  
     *  - port: port number to use for binding the SNMP adaptor.
     * 
     * If you don't specify any port number, the default value is 8086.
     */
    public static void main(String argv[]) {
	
        // If not specified, the default port is 8086.
        //
        int port= 8086;
	
        // The port can be specified in the command line.
        //
        if (argv.length != 0) {
            if (argv.length == 1) {
                try {
                    port= Integer.parseInt(argv[0]);
                }
                catch (NumberFormatException e) {
                    java.lang.System.err.println("Exception occured: " + e);
                    e.printStackTrace();
                    java.lang.System.exit(1);
                }
            }
            else {
                usage();
                java.lang.System.exit(1);
            }
        }
        
        Debug.parseDebugProperties();
        Debug.println("Default debug is on.");

        try {

            AdaptorServerImpl adpSnmp= new AdaptorServerImpl(port);
            java.lang.System.out.println("\nAdding SNMP adaptor using port " + port);

            // Start the adaptor.
            //
            adpSnmp.performStart();

            // Create and initialize the subset of MIB II.
            // The name of the class depends on the name of the module in the mib.
            //
            RFC1213_MIB mib2= new RFC1213_MIB();
            mib2.init();
            java.lang.System.out.println("\nInitializing the MIB " + mib2.getMibName());

            // Bind the SNMP adaptor to the MIB in order to make the MIB accessible through the SNMP protocol.
            //
            mib2.setSnmpAdaptor(adpSnmp);
        }
        catch (Exception e) {
            java.lang.System.err.println("Exception occured: " + e);
            e.printStackTrace();
        }
    }
  
    /**
     * Return usage of the program.
     */
    public static void  usage() {
        java.lang.System.out.println("\nUsage: java StandAloneAgent <port>");
        java.lang.System.out.println("where");
        java.lang.System.out.println("\t-port: port number to use.");
        java.lang.System.out.println("\t       This parameter is not mandatory.");
        java.lang.System.out.println("\t       If not specified, the default port is 8086.\n");
    }
}
