// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)Manager.java 1.4 99/03/12 SMI"

// jaw imports.
//
import com.sun.jaw.reference.common.*;
import com.sun.jaw.snmp.common.*;
import com.sun.jaw.snmp.manager.*;


/**
 * The Manager class is a simple example showing how to use the SNMP Manager API.
 * 
 * When calling the program, you must specify:
 *      - host: hostname of the SNMP agent you want to query.
 *      - port: port number to use.
 * 
 * The provided SNMP agent uses port 8085.
 * To query this agent, invoke the program as follows:
 *      java Manager ibiza 8085
 */

public class Manager  {
   
    /**
     * The main method allows you to specify the following optional command-line parameters:  
     *  1) host: hostname of the SNMP agent you want to query.
     *  2) port: port number to use.
     * 
     * If you wish to query the provided SNMP agent, use port 8085.
     */
    public static void main(String argv[]) {
	
        if (argv.length != 2) {
            usage();
            java.lang.System.exit(1);
        }
    
        String host= argv[0];
        String port= argv[1];

        Debug.parseDebugProperties();
        Debug.println("Default debug is on.");
  
        try {
	  
            SnmpMain.initializeSNMP();
            MibStore.addMib(new RFC1213_MIBStore());
            MibStore.addMib(new DEMO_MIBStore());
	  
            SnmpPeer		agent= new SnmpPeer(host, Integer.parseInt(port));
            SnmpParameters	params= new SnmpParameters("public", "private");
            SnmpSession		session= new SnmpSession("Manager session");
	  
            // We update the time out to let the agent enough time 
            // to do his job before retry.
            agent.setTimeout(100000);
            agent.setSnmpParam(params);
            session.setDefaultPeer(agent);

            // We query demo and system groups of DEMO_MIB and RFC1213_MIB respectively.
            // The DEMO_MIB has been loaded by the local Agent.
            // The RFC1213_MIB has been loaded by the remote StandAloneAgent.
            //
            SnmpRequest		request= null;
            SnmpVarbindList	result= null;
            boolean		completed= false;
            int			errorStatus= 0;
            int			errorIndex= 0;
	  
            SnmpVarbindList list= new SnmpVarbindList("Manager varbind list");
      
            SnmpVar avar1= new SnmpVar("demoString.0") ;
            SnmpVar avar2= new SnmpVar("demoInteger.0") ;
            SnmpVar avar3= new SnmpVar("demoOid.0") ;
            SnmpVar avar4= new SnmpVar("sysDescr.0") ;
            SnmpVar avar5= new SnmpVar("sysContact.0") ;
            SnmpVar avar6= new SnmpVar("sysName.0") ;

            list.addVariable(avar1);
            //list.addVariable(avar2);	// RO: the set operation would fail...
            list.addVariable(avar3);
            //list.addVariable(avar4);	// RO: the set operation would fail...
            list.addVariable(avar5);
            list.addVariable(avar6);
          
            // First get request.
            //
            java.lang.System.out.println("\n>> =====================================================================");
            java.lang.System.out.println(">> Manager: Sending get request to SNMP agent on " + host + " using port " + port);
            request= session.snmpGet(null, list);
            java.lang.System.out.println("\nRequest:\n" + request.toString());

            completed= request.waitForCompletion(10000);
            if (completed == false) {
                java.lang.System.out.println("\nRequest timed out: check reachability of agent.");
                java.lang.System.exit(1);
            }
            errorStatus= request.getErrorStatus();
            errorIndex= request.getErrorIndex() + 1;
            if (errorStatus != SnmpDefinitions.snmpRspNoError) {
                java.lang.System.out.println("\nError status= " + SnmpRequest.snmpErrorToString(errorStatus));
                java.lang.System.out.println("Error index = " + errorIndex);
            } else {
                result= request.getResponseVbList();
                java.lang.System.out.println("\nResult: \n" + result.vbListToString());
            }
	  
            // Set request.
            //
            avar1.setSnmpValue(new SnmpString("! My new demoString !"));
            avar2.setSnmpValue(new SnmpInt(456));
            avar3.setSnmpValue(new SnmpOid("1.3.6.1.4.1.43"));
            avar4.setSnmpValue(new SnmpString("! My new sysDescr !"));
            avar5.setSnmpValue(new SnmpString("! My new sysContact !"));
            avar6.setSnmpValue(new SnmpString("! My new sysName !"));
	  
            java.lang.System.out.println("\n>> =====================================================================");
            java.lang.System.out.println(">> Manager: Sending set request to SNMP agent on " + host + " using port " + port);
            request= session.snmpSet(null, list);
            java.lang.System.out.println("\nRequest:\n" + request.toString());

            completed= request.waitForCompletion(10000);
            if (completed == false) {
                java.lang.System.out.println("\nRequest timed out: check reachability of agent.");
                java.lang.System.exit(1);
            }
            errorStatus= request.getErrorStatus();
            errorIndex= request.getErrorIndex() + 1;
            if (errorStatus != SnmpDefinitions.snmpRspNoError) {
                java.lang.System.out.println("\nError status= " + SnmpRequest.snmpErrorToString(errorStatus));
                java.lang.System.out.println("Error index = " + errorIndex);
            } else {
                result= request.getResponseVbList();
                java.lang.System.out.println("\nResult: \n" + result.vbListToString());
            }
	  
            // Second get request.
            //
            java.lang.System.out.println("\n>> =====================================================================");
            java.lang.System.out.println(">> Manager: Sending get request to SNMP agent on " + host + " using port " + port);
            request= session.snmpGet(null, list);
            java.lang.System.out.println("\nRequest:\n" + request.toString());

            completed= request.waitForCompletion(10000);
            if (completed == false) {
                java.lang.System.out.println("\nRequest timed out: check reachability of agent.");
                java.lang.System.exit(1);
            }
            errorStatus= request.getErrorStatus();
            errorIndex= request.getErrorIndex() + 1;
            if (errorStatus != SnmpDefinitions.snmpRspNoError) {
                java.lang.System.out.println("\nError status= " + SnmpRequest.snmpErrorToString(errorStatus));
                java.lang.System.out.println("Error index = " + errorIndex);
            } else {
                result= request.getResponseVbList();
                java.lang.System.out.println("\nResult: \n" + result.vbListToString());
            }
	  
            // getNext request.
            //
            java.lang.System.out.println("\n>> =====================================================================");
            java.lang.System.out.println(">> Manager: Sending getNext request to SNMP agent on " + host + " using port " + port);
            request= session.snmpGetNext(null, list);
            java.lang.System.out.println("\nRequest:\n" + request.toString());

            completed= request.waitForCompletion(100000);
            if (completed == false) {
                java.lang.System.out.println("\nRequest timed out: check reachability of agent.");
                java.lang.System.exit(1);
            }
            errorStatus= request.getErrorStatus();
            errorIndex= request.getErrorIndex() + 1;
            if (errorStatus != SnmpDefinitions.snmpRspNoError) {
                java.lang.System.out.println("\nError status= " + SnmpRequest.snmpErrorToString(errorStatus));
                java.lang.System.out.println("Error index = " + errorIndex);
            } else {
                result= request.getResponseVbList();
                java.lang.System.out.println("\nResult: \n" + result.vbListToString());
            }
	  
            // Nicely stop the session.
            //
            session.destroySession();
            java.lang.System.exit(0);
     
        } catch(Exception e) {
            java.lang.System.err.println("Exception occured: " + e );
            e.printStackTrace();
            java.lang.System.exit(1);
        }
    }
  
    public static void  usage() {
        java.lang.System.out.println("\nUsage: java Manager <local_host> <port>");
        java.lang.System.out.println("where");
        java.lang.System.out.println("\t-local_host: hostname of the SNMP agent you want to query.");
        java.lang.System.out.println("\t-port: port number to use.\n");
    }
}
