// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)Agent.java 1.5 99/03/12 SMI"

// jaw imports.
//
import com.sun.jaw.reference.agent.cmf.*;
import com.sun.jaw.reference.common.*;
import com.sun.jaw.reference.agent.services.*;
import com.sun.jaw.snmp.agent.*;


/**
 * The Agent class provides an example on how to use the SNMP proxy.
 * This agent is able to serve local MIBs as well as remote MIBs (that is MIBs running outside the VM where the agent is running).
 * It acts as the single point of contacts for a set of MIBs or sub-agents.
 * 
 * A local DEMO-MIB is loaded and initialized.
 * An SNMP proxy is initialized and allows to query remote MIBs. 
 * 
 * The SNMP adaptor of the agent is started on port 8085.
 * The SNMP proxy will query the specified host using the specified port number. 
 */

public class Agent {

    /**
     * The main> method allows you to specify the following optional command-line parameters:  
     *  1) host: hostname of the remote SNMP sub-agent you want to query.
     *  2) port: port number to use.
     */
    public static void main(String argv[]) {
	
        if (argv.length != 2) {
            usage();
            java.lang.System.exit(1);
        }
    
        String host= argv[0];
        String port= argv[1];
    
        Framework	cmf;
        MoRepSrvIf	rep;
        Class		repSrv;
        String		domain;

        Debug.parseDebugProperties();
        Debug.println("Default debug is on.");
    
        String repClassName		= "com.sun.jaw.impl.agent.services.light.RepositorySrv";
        String mtdClassName		= "com.sun.jaw.impl.agent.services.light.MetaDataSrv";
        String adpHtmlClassName		= "com.sun.jaw.impl.adaptor.html.AdaptorServerImpl";
        String adpRmiClassName		= "com.sun.jaw.impl.adaptor.rmi.AdaptorServerImpl";
        String adpSnmpClassName		= "com.sun.jaw.impl.adaptor.snmp.AdaptorServerImpl";
	
        String localMibClassName	= "DEMO_MIB";
        String remoteMibClassName	= "SnmpMibAgentImpl";

        int htmlPort= 8082;
        int rmiPort= 1099;
        int snmpPort= 8085;
    
        try {
	  
            repSrv = Class.forName(repClassName);
            rep    = (MoRepSrvIf)repSrv.newInstance();
            cmf    = new Framework((MoRepSrvIf)rep, null);
            domain = cmf.getDomain();

            // Create a metadata service.
            //
            cmf.newObject(mtdClassName, domain + ":" + ServiceName.META, null);

            // Add the HTML adaptor service.
            //
            String adpHtmlName= new String(domain + ":com.sun.jaw.adaptor.AdaptorMO.protocol=html,port=" + htmlPort);
            cmf.newObject(adpHtmlClassName, adpHtmlName, null);
            java.lang.System.out.println("\nAdding HTML adaptor using port " + htmlPort);

            // Add the RMI adaptor service.
            //
            String adpRmiName= new String(domain + ":com.sun.jaw.adaptor.AdaptorMO.protocol=rmi,port=" + rmiPort);
            cmf.newObject(adpRmiClassName, adpRmiName, null);
            java.lang.System.out.println("\nAdding RMI adaptor using port " + rmiPort);
      
            // Add the SNMP adaptor service.
            //
            String adpSnmpName= new String(domain + ":com.sun.jaw.adaptor.AdaptorMO.protocol=snmp,port=" + snmpPort);
            cmf.newObject(adpSnmpClassName, adpSnmpName, null);
            java.lang.System.out.println("\nAdding SNMP adaptor using port " + snmpPort);
      
            // Create and initialize the local MIB Demo.
            //
            String localMibName= new String("snmp:DEMO_MIB");
            DEMO_MIB localMib= (DEMO_MIB)cmf.newObject(localMibClassName, localMibName, null);
            java.lang.System.out.println("\nInitializing the MIB " + localMibName);
      
            // Bind the SNMP adaptor to the MIB in order to make the MIB accessible through the SNMP protocol.
            //
            localMib.setSnmpAdaptorName(adpSnmpName);
	  
            // Create and initialize the SNMP proxy.
            //
            String remoteMibName= new String("snmp:proxy");
            SnmpMibAgentImpl remoteMib= (SnmpMibAgentImpl)cmf.newObject(remoteMibClassName, remoteMibName, null);
            remoteMib.initializeProxy(host, Integer.parseInt(port), "1.3.6.1.2.1");
            java.lang.System.out.println("\nInitializing the SNMP proxy " + remoteMibName + " to query host " + host + " using port " + port);
	        
            // Bind the SNMP adaptor to the MIB in order to make the MIB accessible through the SNMP protocol.
            //
            ((SnmpMibAgent)remoteMib).setSnmpAdaptorName(adpSnmpName);
	  
        } 
        catch (Exception e) {
            java.lang.System.err.println("\nException occured: " + e );
            e.printStackTrace();
            java.lang.System.exit(1);
        }
    }
  
    public static void  usage() {
        java.lang.System.out.println("\nUsage: java Agent <remote_host> <port>");
        java.lang.System.out.println("where");
        java.lang.System.out.println("\t-remote_host: hostname of the remote SNMP sub-agent you want to query.");
        java.lang.System.out.println("\t              This remote agent can be either the StandAloneAgent or an SNMP daemon.");
        java.lang.System.out.println("\t-port: port number to use.\n");
    }
}
