// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)TrapListenerImpl.java 3.3 99/03/12 SMI"


import com.sun.jaw.snmp.manager.*;
import com.sun.jaw.snmp.common.*;

/**
 * This class implements the SnmpTrapListener interface.
 * The callback method processSnmpTrap is called when a valid trap PDU is received.
 */

public class TrapListenerImpl implements SnmpTrapListener {

    public void processSnmpTrap(SnmpPduTrap trap) {
        java.lang.System.out.println("NOTE: TrapListenerImpl received Trap :");
        java.lang.System.out.println("\tGeneric "+trap.genericTrap);
        java.lang.System.out.println("\tSpecific "+trap.specificTrap);
        java.lang.System.out.println("\tTimeStamp "+	trap.timeStamp);
        java.lang.System.out.println("\tAgent adress "+trap.agentAddr.stringValue());
    }
}
