// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)SimpleManager.java 3.3 99/03/12 SMI"

import java.io.*;
import java.net.*;
import java.util.*;
import com.sun.jaw.snmp.common.*;
import com.sun.jaw.snmp.manager.*;

// import debug stuff
//
import com.sun.jaw.reference.common.*;


/**
 * The class is a simple example showing how to use the SNMP Manager API.
 *
 * When calling the program, you must specify:
 *      - host: hostname of the SNMP agent you want to query.
 *      - port: port number to use.
 *
 * As a reminder, if you wish to query the SNMP agent example provided
 * as part of JDMK, use port 8085.
 *
 * In order to get traces from the SNMP Manager API, invoke the program as follows:
 *      java -DDEBUG SimpleManager sky 8085
 *
 * @version     3.3     03/12/99
 * @author      Sun Microsystems, Inc
 */

public class SimpleManager  {
   
    /**
     * Main entry point.
     * When calling the program, you must specify:
     *  1) host: hostname of the SNMP agent you want to query.
     *  2) port: port number to use.
     *
     * As a reminder, if you wish to query the SNMP agent example provided
     * as part of JDMK, use port 8085.
     *
     * In order to get traces from the SNMP Manager API, invoke the program as follows:
     *  java -DDEBUG SimpleManager sky 8085
     */
    public static void main(String argv[]) {
     
        if (argv.length != 2) {
            usage();
            java.lang.System.exit(1);
        }
    
        String host= argv[0];
        String port= argv[1];
   
        //
        // Initialize debug property. If you want to get traces while using  the
        // SNMP Manager API, invoke the program with "-DDEBUG_SNMP".
        // 
        Debug.parseDebugProperties();
  
        try {
            // 
            // Initialize the SNMP Manager API.
            // The default MibStore will be used. The predefined knowledge of the default MibStore
            // is limited to the system group of MIB II.
            //
            SnmpMain.initializeSNMP();
       
            //
            // Create a SnmpPeer object for representing the entity to communicate with. 
            //
            SnmpPeer agent= new SnmpPeer(host, Integer.parseInt(port));
     
            //
            // Create parameters to associate to the enity to communicate with..
            // When creating the parameter object, you can specify the read and write community to
            // be used when querying the agent.
            // 
            SnmpParameters params= new SnmpParameters("public", "private");
       
            // 
            // The newly created parameter must be associated to the agent.
            //
            agent.setSnmpParam(params);
     
            //
            // Build the session. A session creates, controls and manages one or more requests 
            //
            SnmpSession session= new SnmpSession("SimpleManager session");
       
            //
            // A default peer (agent) can be associated to a SnmpSession. When invoking a service
            // provided by the SnmpSession, if the agent is not specified, the session will perform
            // the service using the default peer as the target of the service.
            //
            session.setDefaultPeer(agent);
     
            //
            // Build the list of variables you want to query.
            // For debug purposes, you can associate a name to your list.
            //
            SnmpVarbindList list= new SnmpVarbindList("SimpleManager varbind list");
     
            //
            // We want to read the "sysDescr" variable.
            //
            list.addVariable("sysDescr.0");
    
            //
            // Make the SNMP get request and wait for the result.
            //
            SnmpRequest request= session.snmpGet(null, list);
            java.lang.System.out.println("SimpleManager::main: Send get request to SNMP Agent on " + host + " at port " + port);
            boolean completed= request.waitForCompletion(10000);
       
            // 
            // Check for a timeout of the request.
            //
            if (completed == false) {
                java.lang.System.out.println("SimpleManager::main: Request timed out. Check reachability of agent");
	 
                //
                // Print request.
                //
                java.lang.System.out.println("Request: " + request.toString());
                java.lang.System.exit(0);
            }
     
            //
            // Now we have a response. Check if the response contains an error.
            //
            int errorStatus= request.getErrorStatus();
            if (errorStatus != SnmpDefinitions.snmpRspNoError) {
                java.lang.System.out.println("Error status= " + SnmpRequest.snmpErrorToString(errorStatus));
                java.lang.System.out.println("Error index= " + request.getErrorIndex());
                java.lang.System.exit(0);
            }
       
            //
            // Now we shall display the content of the result.
            //
            SnmpVarbindList result= request.getResponseVbList();
            java.lang.System.out.println("Result: \n" + result);
       
            // 
            // Nicely stop the session
            //
            session.destroySession();
       
            //
            // That's all !
            //
            java.lang.System.exit(0);
     
        } catch(Exception e) {
            java.lang.System.err.println("SimpleManager::main: Exception occured:" + e );
            e.printStackTrace();
        }
    }
   
    /**
     * Return usage of the program.
     */
    public static void  usage() {
        java.lang.System.out.println("java SimpleManager host port");
        java.lang.System.out.println("where");
        java.lang.System.out.println("\t-host:hostname or IP address of the SNMP agent you want to query.");
        java.lang.System.out.println("\t-port: port number to use.");
    }
}
