// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)AsyncRspHandler.java 3.3 99/03/12 SMI"

import java.io.*;
import java.net.*;
import java.util.*;
import com.sun.jaw.snmp.common.*;
import com.sun.jaw.snmp.manager.*;


/**
 * This class is a simple implementation of response handler.
 *
 * The class is used by the AsyncManager manager for handling
 * responses.
 *
 * @version     3.3     03/12/99
 * @author      Sun Microsystems, Inc
 */

public class AsyncRspHandler implements SnmpHandlerIf {
   
    /**
     * Create a handler.
     * When an error is received, the caller will be reactivated.
     */
    public AsyncRspHandler(Thread caller) {
        this.caller= caller;
    }
   
    public  void processSnmpPollData(SnmpRequest request, int errStatus, int errIndex, SnmpVarbindList vblist) {
     
        java.lang.System.out.println("processSnmpPollData: " + request.toString());
     
        java.lang.System.out.println("errStatus= " + SnmpRequest.snmpErrorToString(errStatus) + " errIndex= " + errIndex);
     
        //
        // Check if a result is available.
        //
        if (request.getRequestStatus() == Request.stResultsAvailable) {
            // A result is available. Go and get it !
            //
            SnmpVarbindList result= request.getResponseVbList();
            java.lang.System.out.println("Result= " + result.vbListToString());
        }
     
        //
        // Check the error status.
        //
        int errorStatus= request.getErrorStatus();
        if (errorStatus != SnmpDefinitions.snmpRspNoError) {
       
            //
            // Reactivate the user of the handler
            //
            caller.resume();
        }
    }
   
    public  void processSnmpPollTimeout(SnmpRequest request) {
        java.lang.System.out.println("processSnmpPollTimeout: " + request.toString());
        if (request.getRequestStatus() == Request.stResultsAvailable) {
            // A result is available. Go and get it !
            //
            SnmpVarbindList result= request.getResponseVbList();
            java.lang.System.out.println("Result= " + result.vbListToString());
        }
     
        caller.resume();
    }
      
    public  void processSnmpInternalError(SnmpRequest request, String errmsg) {
        java.lang.System.out.println("processSnmpInternalError: " + request.toString());
        java.lang.System.out.println("Error is: " + errmsg);
     
        caller.resume();
    }
   
   
    private Thread caller;
}
