// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)AsyncManager.java 3.3 99/03/12 SMI"

import java.io.*;
import java.net.*;
import java.util.*;
import com.sun.jaw.snmp.common.*;
import com.sun.jaw.snmp.manager.*;

// import debug stuff
//
import com.sun.jaw.reference.common.*;


/**
 * The class shows how to:
 *      - use the Mibstore generated by mibgen
 *      - write and use a SnmpHandlerIf
 *      - deal with asynchronous requests
 *      - listen to traps sent by an agent
 *
 * @version     3.3     03/12/99
 * @author      Sun Microsystems, Inc
 *
 * @see com.sun.jaw.snmp.manager.SnmpHandlerIf
 * @see AsyncRspHandler
 */

public class AsyncManager {
   
    /**
     * Main entry point.
     * When calling the program, you must specify:
     *  1) host: hostname of the SNMP agent you want to query.
     *  2) port: port number to use.
     *
     * As a reminder, if you wish to query the SNMP agent example provided
     * as part of JDMK, use port 8085.
     *
     * In order to get traces from the SNMP Manager API, invoke the program as follows:
     *  java -DDEBUG AsyncManager sky 8085
     */
    public static void main(String argv[]) {
     
        if (argv.length != 2) {
            usage();
            java.lang.System.exit(1);
        }
    
        String host= argv[0];
        String port= argv[1];
   
        //
        // Initialize debug property. If you want to get traces while using  the
        // SNMP Manager API, invoke the program with "-DDEBUG_SNMP".
        // 
        Debug.parseDebugProperties();
  
        try {
       
            //
            // Use the MibStore generated by migen when compiling MIB II.
            //
            MibStore aStore=new RFC1213_MIBStore();
       
            //
            // Simple use of the MibStore.
            //
            String[] meta = aStore.resolveMibVariable("udpLocalPort");
            java.lang.System.out.println("AsyncManager::main: variable= " + 
                                         meta[0] + " oid= " + meta[1] + " type= " + 
                                         aStore.mapTypeToName(aStore.mapNameToType(meta[2])));
            // 
            // Initialize the SNMP Manager API.
            // Specify the mibStore containing all the MIB II knowledge.
            //
            SnmpMain.initializeSNMP(aStore);
       
            //
            // At any time, it is possible to add knowlegde in the MibStore.
            // For instance, we could start the Manager API like that:
            //    SnmpMain.initializeSNMP();
            // Then over time, MIB knowlegde can be added as follows:
            //    MibStore.addMib(aStore);
            //
       
            // Create a SnmpPeer object for representing the entity to communicate with. 
            //
            SnmpPeer agent= new SnmpPeer(host, Integer.parseInt(port));
     
            //
            // Create parameters to associate to the enity to communicate with..
            // When creating the parameter object, you can specify the read and write community to
            // be used when querying the agent.
            // 
            SnmpParameters params= new SnmpParameters("public", "private");
       
            // 
            // The newly created parameter must be associated to the agent.
            //
            agent.setSnmpParam(params);
     
            //
            // Build the session. A session creates, controls and manages one or more requests 
            //
            SnmpSession session= new SnmpSession("AsyncManager session");
       
            //
            // A default peer (agent) can be associated to a SnmpSession. When invoking a service
            // provided by the SnmpSession, if the agent is not specified, the session will perform
            // the service using the default peer as the target of the service.
            //
            session.setDefaultPeer(agent);

            // Create a listener and dispatcher for SNMP Traps (SnmpTrapAgent). SnmpTrapAgent is run as
            // a thread and listens for traps in UDP port=agent port+1.
            // Add TrapListenerImpl as SnmpTrapListener.TrapListenerImpl will receive a callback
            // when a valid trap PDU is received.
            //
            SnmpTrapAgent trapAgent=new SnmpTrapAgent(Integer.parseInt(port)+1);         
            trapAgent.addTrapListener(new TrapListenerImpl()); 
            new Thread(trapAgent).start();       
	
            //
            // Build the list of variables you want to query.
            // For debug purposes, you can associate a name to your list.
            //
            SnmpVarbindList list= new SnmpVarbindList("AsyncManager varbind list");
     
            //
            // We want to read the "sysDescr" variable.
            //
            list.addVariable("sysDescr.0");
    
            //
            // Create a simple implementation of a SnmpHandlerIf. 
            // 
            //
            AsyncRspHandler handler= new AsyncRspHandler(Thread.currentThread());
       
            // Make the SNMP walk request.
            // Read all the MIB variables starting at  "sysDescr" and ending up at "sysServices".
            // The responses will be received through the handler we associated to the request.
            SnmpRequest request= session.snmpWalkUntil(handler,list, new  SnmpOid("sysServices"));
       
            java.lang.System.out.println("AsyncManager::main: Start  snmpWalkUntil for SNMP Agent on " + host + " at port " + port);
       
            //
            // Here you could do whatever processing you need, for instance you could run a
            // graphical user interface.
            // In the context of the example, we are just going to wait ...
       
            Thread.currentThread().suspend();

            //
            // Here the handle should have resume the activity of the thread.
            // so the request is over.
            //
       
            //
            // Nicely stop the session
            //
            session.destroySession();
       
            //
            // That's all !
            //
            java.lang.System.exit(0);
     
        } catch(Exception e) {
            java.lang.System.err.println("AsyncManager::main: Exception occured:" + e );
            e.printStackTrace();
        }
    }
   
    /**
     * Return usage of the program.
     */
    public static void  usage() {
        java.lang.System.out.println("java AsyncManager host port");
        java.lang.System.out.println("where");
        java.lang.System.out.println("\t-host:hostname or IP address of the SNMP agent you want to query.");
        java.lang.System.out.println("\t-port: port number to use.");
    }
}
