// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)TableEntryListenerImpl.java 3.3 99/03/12 SMI"

import com.sun.jaw.snmp.agent.*;
import com.sun.jaw.snmp.common.SnmpStatusException;

/**
 * This class receives SnmpTableEntryEvent events when an entry 
 * is added to or removed from the ifTable.  
 */

public class TableEntryListenerImpl implements SnmpTableEntryListener {

    public  void entryAdded(SnmpTableEntryEvent event) {
        java.lang.System.out.println("NOTE: TableEntryListenerImpl received event \"Entry added\":");
        IfEntryImpl added=(IfEntryImpl)event.getEntry();
        try {
            java.lang.System.out.println("\tIfIndex="+ added.getIfIndex());
            java.lang.System.out.println("\tIfMtu="+ added.getIfMtu());
            java.lang.System.out.println("\tIfType="+ added.getIfType());
            java.lang.System.out.println("\tIfDescr="+ added.getIfDescr());
            java.lang.System.out.println("\tIfOperStatus="+ added.getIfOperStatus());
        }
        catch (SnmpStatusException e) {
            e.printStackTrace();
        }
    }

    public  void entryRemoved(SnmpTableEntryEvent event) {}
}
