// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)SystemImpl.java 3.3 99/03/12 SMI"

import java.io.*;
import java.util.*;
import java.net.*;
import com.sun.jaw.impl.adaptor.snmp.*;

// Dependency on Java Dynamic Management Kit.
import com.sun.jaw.reference.common.*;
import com.sun.jaw.snmp.agent.*;
import com.sun.jaw.snmp.common.*;

public class SystemImpl extends System {

    /**
     * Start up time of the agent
     */
    private long startUpTime= 0;

    public SystemImpl(SnmpMib myMib) {
    
        super(myMib);

        // Initialize the system description using some system properties
        //
        try {
            SysDescr= java.lang.System.getProperty("os.name") + " " +
                java.lang.System.getProperty("os.arch") + " " +
                java.lang.System.getProperty("os.version");
        } catch(SecurityException e) {
            // Do not process the exception
        }
    
        // Initialize the system name using the hostname ...
        //
        try {
            SysName= (InetAddress.getLocalHost()).getHostName();
        } catch(UnknownHostException e) {
            // Do not process the exception
        }
    
        // Initialize the system contact using some system properties
        //
        try {
            SysContact= java.lang.System.getProperty("user.name");
        } catch(SecurityException e) {
            // Do not process the exception
        }
    
        // Initialize the set of services. Assume the agent only deals with application layer.
        //
        SysServices= new Integer(72);

        // Initialize the location with a dummy string
        //
        SysLocation= new String("Sample implementation of system group.");
    
        // For the sysUpTime, use the time the agent started ...
        //
        startUpTime= java.lang.System.currentTimeMillis();
    
    }

    /**
     * @exception SnmpStatusException An error occurred while accessing a MIB node.
     */
    public Long getSysUpTime() throws SnmpStatusException {
    
        long diff= java.lang.System.currentTimeMillis() - startUpTime;
    
        return new Long(diff);
    }
}
