// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)StandAloneSnmpAgent.java 3.4 99/03/12 SMI"

import	com.sun.jaw.impl.adaptor.snmp.*;
import	com.sun.jaw.reference.common.*;
import	com.sun.jaw.snmp.agent.*;

/**
 *
 * The example shows how to write a standalone SNMP agent using
 * Java Dynamic Management Kit.
 * 
 * The agent is started on a non standard SNMP port: 8085. 
 * As such you do not need to be root to start the agent.
 *
 * @version     1.1     04/10/98
 * @author      Sun Microsystems, Inc
 */
public class StandAloneSnmpAgent {

    static AdaptorServerImpl snmpStack= null;

    /**
     * The main method does not allow you to specify command-line
     * parameters.
     */
    public static void main(String args[]) {
  
        Debug.parseDebugProperties();
        Debug.println("Default debug is on");

        try {

            //
            // Bind the adaptor. By default port 161 is used.
            // For the example, we are going to use a on standard port.
            //
            // If you wish to use the standard SNMP ports, just comment out the 
            // following line:
            // port= 8085;
            //
            int port= 161;
            port= 8085;
            snmpStack= new AdaptorServerImpl(port);
            java.lang.System.out.println("NOTE: SNMP Adaptor is bound on port " + port);

            // 
            // Start the adaptor
            //
            snmpStack.performStart();

            //
            // Send a coldStart SNMP Trap
            // Note that this must be done after the performBind!
            //
            java.lang.System.out.print("NOTE: Sending a coldStart SNMP Trap to each destination defined in the ACL file... ");
            snmpStack.sendTrap(0, 0, null);
            java.lang.System.out.println("Done.");

            //
            // Create the MIB
            // The name of the class depends on the name of the module in the mib.
            //
            RFC1213_MIB mib2= new RFC1213_MIB();

            //
            // Initialize the MIB and its associated metadata.
            //
            mib2.init();

            //
            // Register the mib into the adaptor.
            // (This will no longer be required in JDMK 3.0).
            //
            //snmpStack.addMib(mib2);

            //
            // Bind the MIB to the previously created adaptor.
            //
            mib2.setSnmpAdaptor(snmpStack);

            //
            // Create a LinkTrapGenerator.
            //
            int ifIndex= 1;
            LinkTrapGenerator trapGenerato = new LinkTrapGenerator(ifIndex);

            //
            // That's it : we have a SNMP agent running ...
            //

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    static public AdaptorServerImpl getSnmpAdaptor() {
        return snmpStack;
    }
}
