// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)SnmpPduFactoryImpl.java 1.4 99/03/12 SMI"

import java.util.*;
import java.net.*;
import com.sun.jaw.snmp.common.*;

/**
 * This class implements the SnmpPduFactoryIf in order to filter the received 
 * messages according to the host that sent them.  
 */

public class SnmpPduFactoryImpl implements SnmpPduFactoryIf {

    private String[] hostNames;

    /**
     * @param <VAR>hostNames</VAR> The array of the host names whose requests
     * will be refused by the agent.
     */

    public SnmpPduFactoryImpl(String[] hostNames) {
        this.hostNames=hostNames;
    }

    /**
     * This method is called when a pdu is received. If the sender's name figures
     * in the list of "denied" hosts then the method returns null (pdu rejected).
     */

    public SnmpPduPacket decodePdu(SnmpMessage msg)  
        throws SnmpStatusException {
        String from=msg.address.getHostName();
        java.lang.System.out.println("NOTE : SnmpPduFactoryImpl received pdu from host "+from);
        for (int i=0;i<hostNames.length;i++)
            {
                if (from.equals(hostNames[i]))
                    {
                        java.lang.System.out.println("NOTE : Pdu rejected ...");
                        return null;
                    }
            }    
        return msg.decodePdu() ;    
    }


    /**
     * This method is called when a pdu is sent.
     */

    public SnmpMessage encodePdu(SnmpPduPacket pdu, int maxPktSize) 
        throws SnmpStatusException, SnmpTooBigException {
        SnmpMessage result = new SnmpMessage() ;
        result.encodePdu(pdu, maxPktSize) ;
        return result ;    
    }
}
