// Copyright (c) 09/29/98, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)SecureAgent.java 1.3 98/09/28 SMI"

import	java.util.Vector;

import	com.sun.jaw.reference.agent.cmf.*;
import	com.sun.jaw.reference.common.*;
import	com.sun.jaw.reference.agent.services.*;
import  com.sun.jaw.impl.agent.services.mlet.*;

import com.sun.jaw.impl.adaptor.snmp.* ;


/**
 * The SecureAgent class provides a simple example on how to
 * use the SnmpPduFactoryIf interface.
 * for filtering incoming pdus according to the host that sends them.
 * This agent uses the same MIB (RFC1213) and the same SNMP port as the 
 * Agent.
 *
 * @version     1.1     09/28/98
 * @author      Sun Microsystems, Inc
 */
public class SecureAgent {

    static AdaptorServerImpl snmpAdaptor= null;

    /**
     * The main method allows you to specify the following 
     * command-line parameters:  
     * The names of the hosts whose pdus the agent will reject upon reception.
     * The trace level  using the DEBUG properties. 
     * For more information on trace levels, refer to the Debug object.
     */
    public static void main(String args[]) {
        Framework 	        cmf;
        MoRepSrvIf	        rep;
        Class		repSrv;
        String		repName;
        String		mtdName;
        String		adpNameHtml;
        String		adpNameRmi;
        String              adpNameSnmp;
        String              mibClassName;
        String		domain;
        ObjectName      	objName;


        Debug.parseDebugProperties();
        Debug.println("Default debug is on");
    
        repName     = "com.sun.jaw.impl.agent.services.light.RepositorySrv";
        mtdName     = "com.sun.jaw.impl.agent.services.light.MetaDataSrv";
        adpNameHtml = "com.sun.jaw.impl.adaptor.html.AdaptorServerImpl";
        adpNameRmi  = "com.sun.jaw.impl.adaptor.rmi.AdaptorServerImpl";
        adpNameSnmp = "com.sun.jaw.impl.adaptor.snmp.AdaptorServerImpl";
    
        mibClassName= "RFC1213_MIB";

        int htmlPort= 8082;
        int rmiPort= 1099;
        int snmpPort= 161;
    
   
        try {
            repSrv = Class.forName(repName);
            rep    = (MoRepSrvIf)repSrv.newInstance();
            cmf    = new Framework((MoRepSrvIf)rep, null);
            domain = cmf.getDomain();

            //
            // Create a metadata service
            //
            cmf.newObject(mtdName, domain + ":" + ServiceName.META, null);
	

            //
            // Add the HTTP adaptor service.
            //
            String htmlName= new String(domain
                                        + ":com.sun.jaw.adaptor.AdaptorMO.protocol=html,port="
                                        + htmlPort);
            Debug.println("Adding " + adpNameHtml + " to CMF with name \n\t" + htmlName);
            cmf.newObject(adpNameHtml, htmlName, null);
            java.lang.System.out.println("NOTE: HTTP Adaptor is bound on TCP port " + htmlPort);

            //
            // Add the RMI adaptor service.
            //
            String rmiName= new String(domain
                                       + ":com.sun.jaw.adaptor.AdaptorMO.protocol=rmi,port="
                                       + rmiPort);
            Debug.println("Adding " + adpNameRmi + " to CMF with name \n\t" + rmiName);
            cmf.newObject(adpNameRmi, rmiName, null);
            java.lang.System.out.println("NOTE: RMI Adaptor is bound on TCP port " + rmiPort);
      
            //
            // SNMP specific code
            //
      
            //
            // Create a SNMP adaptor.
            // Specify the port to use in the object name. If you want to use the standard port (161)
            // comment out the following line:
            // port= 8085;
            //
            snmpPort= 8085;
            String snmpName= new String(domain
                                        + ":com.sun.jaw.adaptor.AdaptorMO.protocol=snmp,port="
                                        + snmpPort);
            Debug.println("Adding " + adpNameSnmp + " to CMF with name \n\t" + snmpName);
            java.lang.System.out.println("NOTE: SNMP Adaptor is bound on UDP port " + snmpPort);
            snmpAdaptor = (AdaptorServerImpl) cmf.newObject(adpNameSnmp, snmpName, null);

            // Use  SnmpPduFactoryImpl class for SnmpPduFactory to filter requests.
            // The agent will reject requests coming from the specified hosts.
            //

            String[] refusedHosts= new String[args.length];
            refusedHosts=args;
            snmpAdaptor.usePduFactory(new SnmpPduFactoryImpl(refusedHosts));      
      
            //
            // Create the MIB II (RFC 1213)
            //
            String mibName= new String("snmp:RFC1213_MIB");
            Debug.println("Adding RFC1213-MIB to CMF with name \n\t" + mibName);
            RFC1213_MIB mib2=  (RFC1213_MIB) cmf.newObject(mibClassName, mibName, null);
      
            //
            // Bind the SNMP adaptor to the MIB in order to make the MIB accessible
            // through the SNMP protocol.
            // If this step is not performed, the MIB will still live in the JDMK agent:
            // its objects will be addressable through HTML/RMI/IIOP but not SNMP.
            //
            mib2.setSnmpAdaptorName(snmpName);


        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    static public AdaptorServerImpl getSnmpAdaptor() {
        return snmpAdaptor;
    }
}



