// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)LinkTrapGenerator.java 3.3 99/03/12 SMI"

import java.io.*;
import java.util.*;

// Dependency on Java Dynamic Management Kit.
import com.sun.jaw.reference.agent.cmf.*;
import com.sun.jaw.reference.common.*;

public class LinkTrapGenerator extends Thread {

    // M-bean properties
    //
    private int ifIndex= -1;
    private int interval= 5000; /* 5 seconds */
    private int successes= 0;
    private int errors= 0;
    private boolean suspended= true;


    public LinkTrapGenerator() {

        super();
        Debug.println("LinkTrapGenerator() called");
        Debug.println("LinkTrapGenerator() returned\n");
    }

    public LinkTrapGenerator(int ifIndex) {

        Debug.println("LinkTrapGenerator(int ifIndex) called");

        this.ifIndex= ifIndex;
        start();
        suspended= false;

        Debug.println("LinkTrapGenerator(int ifIndex) returned\n");
    }

    /**
     * @exception IllegalAccessException The method has tried to access a class that is not public and in another package.
     * @exception ServiceNotFoundException The requested service is not supported.
     * @exception InstanceAlreadyExistException The m-bean is already registered in the repository.
     */
    public void initCmf(Framework cmf, ObjectName name)
        throws IllegalAccessException,
               ServiceNotFoundException,
               InstanceAlreadyExistException {

        Debug.println("LinkTrapGenerator.initCmf() called");

        // Creates an ObjectName if it was not given.
        // NOTE:
        //      The ObjectName can be null if the request was made
        //      throught the M-Let service.
        //
        if (name == null) {
            name= new ObjectName("trapGenerator", this.getClass().getName(),
                                 "ifIndex", new Integer(ifIndex));
        }

        // Extract the value of ifIndex from the name
        //
        Integer index = (Integer) name.getProperty("ifIndex") ;
        if (index != null) {
            ifIndex = index.intValue() ;
        }

        // Register the m-bean into the CMF
        //
        Debug.println("Register a LinkTrapGenerator with object name -> " + name.toString());
        cmf.addObject(this, name);
        Debug.println("Registeration ok");

        // Start the thread
        //
        start();
        suspended= false;

        Debug.println("LinkTrapGenerator.initCmf() returned\n");
    }

    public void deleteCmf() {
        stop();
    }

    public Integer getIfIndex() {
        return new Integer(ifIndex);
    }

    public void setIfIndex(Integer x) {
        ifIndex= x.intValue();
    }

    public String getState() {

        String state = new String();

        state= state + "isAlive: " + isAlive();
        state= state + " - ";
        state= state + "isDaemon: " + isDaemon();
        state= state + " - ";
        state= state + "isInterrupted: " + isInterrupted();
        state= state + " - ";
        state= state + "isSuspended: " + isSuspended();

        return state;
    }

    public boolean isSuspended() {
        return suspended;
    }

    public Integer getSuccesses() {
        return new Integer(successes);
    }

    public Integer getErrors() {
        return new Integer(errors);
    }

    public Integer getInterval() {
        return new Integer(interval);
    }

    public void setInterval(Integer val) {
        interval= val.intValue();
    }

    public void run() {
        while (true) {
            try {
                sleep(interval);
            } catch (Exception e) {
                e.printStackTrace();
            }
            performSend();
        }
    }

    public void performReset() {
        successes= 0;
        errors= 0;
        this.resume();
    }

    public void performSuspend() {
        this.suspend();
        suspended= true;
    }

    public void performResume() {
        this.resume();
        suspended= false;
    }

    public void performSend() {
        IfEntryImpl ifEntryImpl = InterfacesImpl.find(ifIndex);
        if (ifEntryImpl == null) {
            java.lang.System.err.println("ERROR: LinkTrapGenerator.performSend(): ifIndex "
                                         + ifIndex
                                         + " not found");
            errors++;
            return;
        }
        ifEntryImpl.switchifOperStatus();
        successes++;
    }
}

