// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)InterfacesImpl.java 3.3 99/03/12 SMI"

import java.io.*;
import java.util.*;

// Dependency on Java Dynamic Management Kit.
import com.sun.jaw.reference.common.*;
import com.sun.jaw.reference.agent.cmf.*;

import com.sun.jaw.snmp.agent.*;
import com.sun.jaw.snmp.agent.internal.*;
import com.sun.jaw.snmp.common.*;

public class InterfacesImpl extends Interfaces {

    private static IfEntryImpl le0= null;
    private static IfEntryImpl lo0= null;

    public InterfacesImpl(SnmpMib myMib) {

        super(myMib);
        // Add TableEntryListenerImpl as event listener on the table
        IfTable.addSnmpTableEntryListener(new TableEntryListenerImpl());
        init(myMib);
    }

    // Added the cmf parameter to be able
    // to register the interfaces in the CMF
    //
    public InterfacesImpl(SnmpMib myMib, Framework cmf) {

        super(myMib);
        // Add TableEntryListenerImpl as event listener on the table
        IfTable.addSnmpTableEntryListener(new TableEntryListenerImpl());
        init(myMib);

        // Register le0 and lo0 into the CMF

        le0.addInCmf(cmf);
        lo0.addInCmf(cmf);
    }

    private void init(SnmpMib myMib) {

        IfNumber= new Integer(2);

        le0= new IfEntryImpl(myMib);
        le0.IfIndex= new Integer(1);
        le0.IfMtu= new Integer(1500);
        le0.IfType= new EnumIfType(6); // "ethernet-csmacd"
        le0.IfDescr= new String("le0");
        le0.IfOperStatus= new EnumIfOperStatus(1); // "up"

        lo0= new IfEntryImpl(myMib);
        lo0.IfIndex= new Integer(2);
        lo0.IfMtu= new Integer(8232);
        lo0.IfType= new EnumIfType(24); // "softwareLoopback"
        lo0.IfDescr= new String("lo0");
        lo0.IfOperStatus= new EnumIfOperStatus(1); // "up"


        // Register le0 and lo0 into the ifTable

        try {
            IfTable.addEntry(le0);
            IfTable.addEntry(lo0);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static IfEntryImpl find(int ifIndex) {
        if (ifIndex == le0.IfIndex.intValue()) {
            return le0;
        } else if (ifIndex == lo0.IfIndex.intValue()) {
            return lo0;
        } else {
            return null;
        }
    }
}



