// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)IfEntryImpl.java 3.3 99/03/12 SMI"

import java.io.*;
import java.util.*;

// Import packages of SNMP adaptor.
import com.sun.jaw.impl.adaptor.snmp.*;

// Dependency on Java Dynamic Management Kit.
import com.sun.jaw.reference.common.*;
import com.sun.jaw.reference.agent.cmf.*;
import com.sun.jaw.snmp.agent.*;
import com.sun.jaw.snmp.common.*;


public class IfEntryImpl extends IfEntry {

    private String prefix= "ifTable:ifEntry.ifIndex=";

    public IfEntryImpl(SnmpMib myMib) {
        super(myMib);
    }

    public void addInCmf(Framework cmf) {
        try {
            cmf.addObject(this, new ObjectName(prefix + IfIndex));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void switchifOperStatus() {

        int status= -1;

        switch(IfOperStatus.intValue()) {
		case 1: // "up
			status= 2;
			break;
		case 2: // "down
			status= 3;
			break;
		case 3: // "testing"
			status= 1;
			break;
        }

        switchifOperStatus(new EnumIfOperStatus(status));
    }

    public void switchifOperStatus(EnumIfOperStatus x) {

        IfOperStatus = x;

        int generic = -1;
        switch(x.intValue()) {
		case 1: // "up
			generic= 3;
			break;
		case 2: // "down
		case 3: // "testing"
			generic= 2;
			break;
        }

        sendTrap(generic);
    }

    public void sendTrap(int generic) {

        AdaptorServerImpl snmpAdaptor= null;

        //
        // Retrieve the reference of the SNMP Adaptor
        //
        snmpAdaptor= Agent.getSnmpAdaptor();
        if (snmpAdaptor == null) {
            snmpAdaptor= StandAloneSnmpAgent.getSnmpAdaptor();
        }
        if (snmpAdaptor == null) {
            java.lang.System.err.println("BUG: IfEntryImpl.sendTrap(): snmpAdaptor is null");
            return;
        }

        String generic_string= null;

        switch (generic) {
		case 3:
			generic_string= "linkUp";
			break;
		case 2:
			generic_string= "linkDown";
			break;
		default:
			java.lang.System.err.println("BUG: IfEntryImpl.sendTrap(): bad generic: "
                                         + generic);
			return;
        }

        Vector varBindList= new Vector();

        SnmpOid oid1= new SnmpOid("1.3.6.1.2.1.2.2.1.1." + IfIndex);
        SnmpInt value1= new SnmpInt(IfIndex);
        SnmpVarBind varBind1= new SnmpVarBind(oid1, (SnmpValue) value1);

        varBindList.addElement(varBind1);

        java.lang.System.out.print("NOTE: Sending a "
                                   + generic_string
                                   + " SNMP Trap for the Interface " 
                                   + IfIndex
                                   + " to each destination defined in the ACL file... ");
        try {
            snmpAdaptor.sendTrap(generic, 0, varBindList);
        } catch (Exception e) {
            e.printStackTrace();
        }
        java.lang.System.out.println("Done.");
    }
}

