// Java imports
//
import java.util.*;

/**
 * This class holds object names regitered with the Restart service.
 * It uses both a Hashtable and a Vector. The hashtable is used
 * for faster retieval while the Vector is used for a queue.
 * Objects are kept in the order they have been added to the list.
 */
public final class RestartList 
    implements java.io.Serializable {

    // CONSTRUCTORS
    //-------------
   
    /**
     * Default constructor.
     */
    public RestartList() {
        queue = new Vector();
        table = new Hashtable();
    }


    // PUBLIC METHODS
    //---------------

    /**
     * Removes the object from the restart list.
     *
     * @param <CODE>object</CODE> The component to be renoved.    
     */
    public void remove(Object object) {
        Integer pos = (Integer)table.remove(object);
        if (pos != null) {
            queue.removeElementAt(pos.intValue());
        }
    }

    /**
     * Adds the object to the end of the restart list.
     *
     * @param <CODE>object</CODE> The component to be added.    
     */
    public void add(Object object) {
        if(table.containsKey(object)) {
            remove(object);
        }
        table.put(object, new Integer(queue.size()));
        queue.addElement(object);
    }
   
    /**
     * Tests if the specified object is a component in this restart list. 
     *
     * @return  True if the specified object is a component in
     * this list; false otherwise.
     */
    public boolean contains(Object object) {
        return table.containsKey(object);
    }
   
    /**
     * Returns an enumeration of the components of this restart list.
     *
     * @return  an enumeration of the components of this list.
     * @see     java.util.Enumeration
     */
    public synchronized Enumeration elements() {
        return queue.elements();
    }

    /**
     * Returns a list of the components of this restart list.
     *
     * @return  a clone of the queue.
     */
    public Vector getAll() {
        return (Vector)queue.clone();
    }
   
    /**
     * Returns the number of components in this restart list.
     *
     * @return  The number of components in this list.
     */
    public int size() {
        return queue.size();
    }
   
    /**
     * Returns a string representation of this restart list.
     *
     * @return  A string representation of this list.
     */
    public String toString() {
        StringBuffer stringbuffer = new StringBuffer();
        int i = queue.size();
        for(int j = 0; j < i; j++) {
            stringbuffer.append("[");
            stringbuffer.append(queue.elementAt(j));
            stringbuffer.append("] \n");
        }
        return stringbuffer.toString();
    }

    // PRIVATE VARIABLES
    //------------------

    /* Table for fast access */
    private Hashtable table;
   
    /* The ordered queue */
    private Vector queue;
}
