// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)ActivationFailure.java 3.3 99/03/12 SMI"

// Jaw imports
//
import com.sun.jaw.reference.common.ObjectName;

// Java imports
//
import java.lang.Exception;

/**
 * This class encapsulates the information describing an activation failure.
 * It contains the name of the m-bean and the exception thrown at activation
 * time.
 */
public class ActivationFailure
    implements java.io.Serializable {

    // CONSTRUCTORS
    //-------------

    /**
     * Creates an activation failure.
     *
     * @param <VAR>name</VAR> The object name of the m-bean.
     * @param <VAR>exp</VAR> The exception thrown on activation.
     */
    public ActivationFailure(ObjectName name, Exception exp) {
        this.name = name;
        this.exp = exp;
    }


    // PUBLIC METHODS
    //---------------

    /**
     * Gets the object name.
     *
     * @return The object name.
     */
    public ObjectName getName() {
        return name;
    }
    /**
     * Gets the exception thrown.
     *
     * @return The exception.
     */
    public Exception getException() {
        return exp;
    }

    // PRIVATE VARIABLES
    //------------------

    /* The objact name of the m-bean */
    private ObjectName name = null;
   
    /* The exception thrown */
    private Exception exp = null;
}
