// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)Queries.java 3.3 99/03/12 SMI"

import  com.sun.jaw.reference.query.*;

/**
 * The Queries class shows how to build some
 * simple queries using the Query package.
 * More complex queries can be built easily by using the appropriate
 * calls to the methods of the Query class as shown in the simple
 * examples described below. 
 *
 * @version     3.3     03/12/99
 * @author      Sun Microsystems, Inc
 */
public class Queries {
  
    /**
     * Build some sample queries.
     *
     */
    public static QueryExp query(int i) {

        switch(i) {

            // Find all objects whose property "Name" matches string "get*"
        case 1 :
            return Query.match(Query.attr("Name"), Query.value("get*"));
	
            // Find all objects whose property "Name" appear before "hashCode"
        case 2 :
            return Query.lt(Query.attr("Name"), Query.value("hashCode"));

            // Find all objects whose property "NbParams" is greater than 2
            // (in fact methods that have more than 2 parameters)
        case 3 :
            return Query.geq(Query.attr("NbParams"), Query.value(2));
	
            // Find all objects whose property "Static" is true
        case 4 :
            return Query.eq(Query.attr("Static"), Query.value(true));
	
            // Find all objects of class "MethodMB"
            // whose property "Name" appear before "hashCode" inclusive
        case 5 :
            return Query.leq(Query.attr("MethodMB", "Name"), Query.value("hashCode"));

            // Find all objects of class "ClassMB"
            // whose property "Public" is true, i.e, find all public classes
        case 6 :
            return Query.eq(Query.attr("ClassMB", "Public"), Query.value(true));

            // Find all objects whose property "Params" is equal to 2 and whose property "Name"
            // is "wait", i.e, find all methods named "wait" with 2 parameters
        case 7 :
            return Query.and(Query.eq(Query.attr("Name"), Query.value("wait")),
                             Query.eq(Query.attr("NbParams"), Query.value(2)));

            // Find all objects whose property "Name" is equal to "java.lang.String"
            // or "java.io", i.e., find all methods of the 2 classes "java.lang.String"
            // and "java.io"
        case 8 :
            return Query.or(Query.eq(Query.attr("ClassName"), Query.value("java.lang.String")),
                            Query.eq(Query.attr("ClassName"), Query.value("java.io.File")));
	
            // Find all objects for which the property "NbParams" is greater > 0 is false
            // i.e. all methods with no parameter
        case 9 :
            return Query.not(Query.gt(Query.attr("NbParams"), Query.value(0)));
	
            // Find all objects whose property "NbParams" is between 1 and 2
            // (in fact methods that have 1 or 2 parameters)
        case 10 :
            return Query.between(Query.attr("NbParams"), Query.value(1), Query.value(2));
	
            // Find all objects whose property "Params" is "int" or "java.lang.String"
            // i.e. all methods with 1 parameter of type int or String
        case 11 :
            ValueExp[] valExps = new ValueExp[2];
            valExps[0] = Query.value("int");
            valExps[1] = Query.value("java.lang.String");
            return Query.in(Query.attr("Params"), valExps);
	
            // Find all objects whose property "Name" starts with "to"
        case 12 :
            return Query.initialSubstring(Query.attr("Name"), Query.value("to"));
	
            // Find all objects whose property "Name" ends with "se"
        case 13 :
            return Query.finalSubstring(Query.attr("Name"), Query.value("se"));
	
            // Find all objects whose property "Name" contains "lang"
        case 14 :
            return Query.anySubstring(Query.attr("Name"), Query.value("lang"));
	
            // Find all objects whose property "Name" starts with "to" and ends with "se"
        case 15 :
            return Query.and(Query.initialSubstring(Query.attr("Name"), Query.value("to")),
                             Query.finalSubstring(Query.attr("Name"), Query.value("se")));
	
            // Find all objects whose property "ParamType" has as 1st element the value "int"
            // i.e, all methods whose 1st parameter is an int.
        case 16 :
            return Query.eq(Query.attr("ParamType", 1), Query.value("int"));

            // Find all objects whose property "PackageHierarchy" to the depth of 2 is
            // equal to "java.lang", i.e, all classes or methods of classes that can be
            // found in the package hierarchy "java.lang".
        case 17 :
            return Query.eq(Query.attr("PackageHierarchy", 2), Query.value("java.lang"));
	
            // Find all objects of class "ClassMB" whose
            // property "PackageHierarchy" to the depth of 2 is equal to "java.lang",
            // i.e, all classes that can be found in the package hierarchy "java.lang".
        case 18 :
            return Query.eq(Query.attr("ClassMB", "PackageHierarchy", 2),
                            Query.value("java.lang"));
	
        default :
            return null;

        }
    }
}
