// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)MethodMB.java 3.3 99/03/12 SMI"

/**
 * M-Bean representing a java class method.
 *
 * The object has the following properties:
 *      - Name: the name of the method
 *      - ClassName: the name of the class containing this method
 *      - Static: states if the method is static or not
 *      - Public: states if the method is public or not
 *      - NbParams: the number of parms of the method
 *      - ParamType: indexed property giving the type of one of the
 *        parameters of the method
 *      - Params: a '_' separated string of the names of all the
 *        parameters of the method
 *      - PackageHierarchy: an indexed property taht gives the hierarchy of the
 *        package to which the class belongs
 */

import java.lang.*;
import java.lang.reflect.*;
import java.util.*;
import com.sun.jaw.reference.common.*;
import com.sun.jaw.reference.agent.cmf.*;

public class MethodMB implements java.io.Serializable {

    /**
     * Default constructor
     */
    public MethodMB() {
    }

    /**
     * Build the MBean and initialize it
     */
    public MethodMB(Method m) {
        method = m;
        paramClasses = m.getParameterTypes();
    }

    /**
     * Getter for the "Name" property. The method
     * is compliant with the Bean design pattern.
     *
     * @return the current value of the "Name" property.
     */
    public String getName() {
        return method.getName();
    }

    /**
     * Getter for the "Params" property. The method
     * is compliant with the Bean design pattern.
     *
     * @return the current value of the "Params" property.
     */
    public String getParams() {
        String params = "";
        if (paramClasses.length == 0)
            params = "NONE";
        else
            for (int i = 0; i < paramClasses.length; i++) {
                if (i > 0)
                    params += "_";
                params += paramClasses[i].getName();
            }
        return params;
    }

    /**
     * Getter for the "NbParams" property. The method
     * is compliant with the Bean design pattern.
     *
     * @return the current value of the "NbParams" property.
     */
    public Integer getNbParams() {
        return new Integer(paramClasses.length);
    }

    /**
     * Getter for the "ParamType" property. The method
     * is compliant with the Bean design pattern.
     *
     * @return the current value of the "ParamType" property.
     */
    public String getParamType(int i) {
        if (i >= paramClasses.length)
            return null;

        return paramClasses[i].getName();
    }

    /**
     * Getter for the "ClassName" property. The method
     * is compliant with the Bean design pattern.
     *
     * @return the current value of the "ClassName" property.
     */
    public String getClassName() {
        return method.getDeclaringClass().getName();
    }

    /**
     * Getter for the "Public" property. The method
     * is compliant with the Bean design pattern.
     *
     * @return the current value of the "Public" property.
     */
    public Boolean getPublic() {
        return new Boolean(Modifier.isPublic(method.getModifiers()));
    }

    /**
     * Getter for the "Static" property. The method
     * is compliant with the Bean design pattern.
     *
     * @return the current value of the "Static" property.
     */
    public Boolean getStatic() {
        return new Boolean(Modifier.isStatic(method.getModifiers()));
    }

    /**
     * Getter for the "PackageHierarchy" property. The method
     * is compliant with the Bean design pattern.
     *
     * @return the current value of the "PackageHierarchy" property.
     */
    public String getPackageHierarchy(int i) {
        StringTokenizer st = new StringTokenizer(getClassName(), ".");
        if (i > st.countTokens())
            i = st.countTokens();

        String result = "";

        for ( ; i > 0; i--) {
            result += st.nextToken();
            if (i > 1)
                result += ".";
        }
    
        return result;
    }

    /**
     * Returns the domain name to use to register this MBean
     */
    public String domainname() {
        return "Methods";
    }

    /**
     * Returns the object name to use to register this MBean
     */
    public ObjectName objectName() {    
        return new ObjectName(domainname()+":"+getClass().getName()+"MO"+
                              ".class="+getClassName()+
                              ",method="+getName()+
                              ",params="+getParams());
    }

    /**
     * reference to the framework
     */
    private Framework cmf;

    /**
     * The Java method corresponding to this MBean
     */
    private Method method;

    /**
     * Classes corresponding to the the parameters
     */
    private Class[] paramClasses;
}
