// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)Client.java 3.3 99/03/12 SMI"

import java.util.*;
import java.net.*;

// jaw import
//
import com.sun.jaw.reference.common.*;
import com.sun.jaw.reference.query.*;
import com.sun.jaw.reference.client.adaptor.*;

/**
 * This class provides a simple example of a client using
 * queries to filter objects obtained from a remote agent.
 *
 * @version     3.3     03/12/99
 * @author      Sun Microsystems, Inc
 *
 */


public class Client implements Runnable {

    // CONSTRUCTOR
    //------------
    public Client() {
    }
  
    /**
     * @exception ClassNotFoundException The specified class could not be found.
     * @exception InstantiationException A new instance of the specified class could not be created.
     * @exception IllegalAccessException The method has tried to access a class that is not public and in another package.
     */
    public Client(String adaptor) throws
    ClassNotFoundException, InstantiationException, IllegalAccessException {

        // Get the implementation requested for the adaptor
        //
        Class factoryClass= Class.forName(adaptor);
	
        // Create the adaptor
        //
        MOFactory= (AdaptorMO) factoryClass.newInstance();
    }	

    /**
     * It is possible to specify on the command line the implementation to use
     * for the adaptor function. 
     */
    public static void main(String args[]) {
	
        System.exit( new Client().execute(args) ) ;	
    }
  
    /**
     * When an object implementing interface Runnable is used to create a thread, 
     * starting the thread causes the object's run method to be called in that
     * separately executing thread.
     */
    public void run() {
	
        String[] s = new String[0];
        execute(s);
    }
  
  
    // GETTERS AND SETTERS
    //--------------------
    /**
     * Returns the version of this class.
     */
    public String getClassVersion() {
        return (sccs_id);
    }
  
  
    // PRIVATE METHODS
    //----------------
    private int execute(String args[]) {
	
        // Get the adaptor to use to talk to the agent
        //
        Properties p= System.getProperties();
        String adaptor;
        if ((adaptor= System.getProperty("ADAPTOR")) == null)
            adaptor= "com.sun.jaw.impl.adaptor.rmi.AdaptorClient";
      
        // Locate the machine where the agent is running
        //
	
        String host;
        if ((host= System.getProperty("HOST")) == null)
            host= "localhost";

        String logicalName;
        if ((logicalName= System.getProperty("NAME")) == null) {
            logicalName= "com.sun.jaw.impl.adaptor.rmi.AdaptorServer";
        }

        String portName;
        int port;
        if ((portName= System.getProperty("PORT")) == null) {
            port= 1099;
        } else {
            port= Integer.parseInt(portName);
        }

        // Try to create a client now
        //
        Client aClient = null;
        try {
            aClient = new Client(adaptor);
        }
        catch (Exception e) {
            Debug.printException(e);
            return 1;
        }
		      
        // Connect the MOFactory of the client to the server
        //
        try {
            aClient.MOFactory.connect(null, host, port, logicalName);
        } 
        catch(Exception e) {
            Debug.printException(e);
            e.printStackTrace();
            return 1;
        }

        // Do the queries
        //
        Client.doQueries(aClient.MOFactory);

        // We're done : exit now
        //
        //System.exit(0);
        return 0;
    }
  
    private static void usage() {
        System.out.println("java -DADAPTOR=\"adaptor\" -DHOST=\"hostname\" -DPORT=\"port\" -NAME=\"name\n Client");
        System.out.println("where\n\tadaptor is class name of the client adaptor");
        System.out.println("\thostname is name of the server");
        System.out.println("\tport is port number to use");
        System.out.println("\name is logical name of server to use");
    }

    private static void doQueries(AdaptorMO adp) {
    
        // Apply the queries to our objects
        //
        QueryExp aQry;
        for (int i = 1; (aQry = Queries.query(i)) != null; i++) {
      
            System.out.print("\nGetting objects that validate the following query :\n\t");
            System.out.println(aQry);
            System.out.println();

            Vector objs = null;
            try {
                objs = adp.getOnlyNames(new ObjectName(":"), aQry);
            } 
            catch(Exception e) {
                System.out.println("Problem getting objects");
                e.printStackTrace();
                System.out.println();
                System.out.println();
            }
      
            if (objs == null  || objs.size() == 0) {
                System.out.println("No match");
            }
            else {
                for (Enumeration e = objs.elements(); e.hasMoreElements(); ) {
                    ObjectName no = (ObjectName) e.nextElement();
                    System.out.println("\t"+no);
                }
            }
      
        }
    }
  

    // PRIVATE VARIABLES
    //------------------
    /**
     * Version of the implementation
     */
    private static final String sccs_id = "@(#)Client.java 3.3 03/12/99 SMI";

    /**
     * MO Adaptor associated to a client instance
     */
    private AdaptorMO MOFactory= null;
}
