// Copyright (c) 03/24/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)ClassMB.java 3.4 99/03/24 SMI"

/**
 * M-Bean representing a java class.
 * The object has the following properties:
 *      - Name: the name of the class
 *      - Public: specifies if the class is public or not
 *      - PackageHierarchy: an indexed property taht gives the hierarchy of the
 *        package to which the class belongs
 *
 * When instantiated, this class registers into the Framework and also
 * registers all its methods into the Framework.
 *
 */

import java.util.*;
import java.lang.reflect.*;
import com.sun.jaw.reference.common.*;
import com.sun.jaw.reference.agent.cmf.*;

public class ClassMB implements java.io.Serializable {

    /**
     * Default constructor
     */
    public ClassMB() {
    }

    /**
     * Build the MBean with the given name
     */
    public ClassMB(String name) {
        this.name = name;
    }

    /**
     * Initialize this MBean.
     * The method will declare the object to the Common Management Framework.
     * The name of the class is contained in the name of the object.
     *
     * @param <VAR>cmf</VAR> CMF to attach the service to.
     * @param <VAR>objName</VAR> object name to use to register the MBean.
     * @exception ClassNotFoundException The specified class could not be found.
     */
    public void initCmf(Framework cmf, ObjectName objName, boolean db, ModificationList list)
        throws ClassNotFoundException {

        try {
            //
            // Keep the framework
            //
            this.cmf = cmf;

            //
            // Register this class
            //
            name = (String) objName.getProperty("name");
            System.out.println("Declaring class "+name);
            try {
                cmf.addObject(this, objName);
            } catch(Exception e) {
                e.printStackTrace();
                return;
            }

   
            Class theClass = Class.forName(name);
            isPublic = Modifier.isPublic(theClass.getModifiers());
            Method[] meths = theClass.getMethods();
            int imeth;
            for (imeth = 0; imeth < meths.length; imeth++) {
                MethodMB mtmb = new MethodMB(meths[imeth]);
                try {
                    cmf.addObject(mtmb, mtmb.objectName());
                } catch(InstanceAlreadyExistException e) {
                    System.out.println("\tMethod "+meths[imeth].getName()+" was already declared for class "+mtmb.getClassName());
                } catch(Exception e) {
                    System.out.println("\tCould not create "+mtmb.objectName()+" ["+e.getMessage()+"]");
                }
            }
     
        } catch(Throwable e) {
            e.printStackTrace();
        }
    }

    /**
     * Getter for the "Name" property. The method
     * is compliant with the Bean design pattern.
     *
     * @return the current value of the "Name" property.
     */
    public String getName() {
        return (name);
    }

    /**
     * Getter for the "Public" property. The method
     * is compliant with the Bean design pattern.
     *
     * @return the current value of the "Public" property.
     */
    public Boolean getPublic() {
        return new Boolean(isPublic);
    }

    /**
     * Getter for the "PackageHierarchy" property. The method
     * is compliant with the Bean design pattern.
     *
     * @return the current value of the "PackageHierarchy" property.
     */
    public String getPackageHierarchy(int i) {
        StringTokenizer st = new StringTokenizer(name, ".");
        if (i > st.countTokens())
            i = st.countTokens();

        String result = "";

        for ( ; i > 0; i--) {
            result += st.nextToken();
            if (i > 1)
                result += ".";
        }
      
        return result;
    }

    /**
     * Returns the domain name to use to register this MBean
     */
    public String domainname() {
        return "Classes";
    }

    /**
     * Returns the object name to use to register this MBean
     */
    public ObjectName objectName() {
        return new ObjectName(domainname()+":"+getClass().getName()+"MO.name="+getName());
    }

    /**
     * reference to the framework
     */
    Framework cmf;

    /**
     * Name of the class
     */
    String name;

    /**
     * Is the class public ?
     */
    boolean isPublic;
}
