// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)Agent.java 3.4 99/03/12 SMI"

import	java.util.*;

import	com.sun.jaw.reference.agent.cmf.*;
import	com.sun.jaw.reference.common.*;
import	com.sun.jaw.reference.agent.services.*;
import  com.sun.jaw.reference.query.*;

/**
 * The purpose of this example is to illustrate the use of the Filter service
 * provided with Java Dynamic Management.
 * 
 * The Filter service makes use of the Query package.
 * 
 * This Agent class is an extension to the simple agent example provided
 * with Java Dynamic Management, which also uses the Filter service.
 * 
 * The MBeans defined for this agent are
 *      - ClassMB: this MBean represents a Java Class
 *      - MethodMB: this MBean represents a method of a Java Class
 * 
 * The classes that the agent must register as class MBeans can be given as arguments.
 * If none is provided, the agent will use a few basic classes as example.
 *
 * Each class that is registered in the framework also registers the methods that
 * are defined within this class.
 *
 * The agent then applies a set of queries when getting the objects from the Framework.
 * The queries that are applied can be examined by looking at the Queries class.
 *
 * @version     3.4     03/12/99
 * @author      Sun Microsystems, Inc
 */
public class Agent {
  
    /**
     * The main method allows you to specify the set of
     * classes which the agent is going to register. 
     * It also allows you to specify the trace level 
     * by using the DEBUG properties.
     * For more information on trace levels, refer to the Debug object.
     */
    public static void main(String args[]) {
        Framework	cmf = null;
        MoRepSrvIf	rep;
        MetaDataSrvIf	mtdSrv;
        Class		repSrv;
        String		repName;
        String		mtdName;
        String		adpNameHtml;
        String		adpNameRmi;
        String		domain = null;
        ObjectName	objName;


        Debug.parseDebugProperties();
        Debug.println("Default debug is on");
    
        repName     = "com.sun.jaw.impl.agent.services.light.RepositorySrv";
        mtdName     = "com.sun.jaw.impl.agent.services.light.MetaDataSrv";
        adpNameRmi  = "com.sun.jaw.impl.adaptor.rmi.AdaptorServerImpl";
        adpNameHtml = "com.sun.jaw.impl.adaptor.html.AdaptorServerImpl";

        try {
            repSrv = Class.forName(repName);
            rep    = (MoRepSrvIf)repSrv.newInstance();

            //
            // Setup JDBC
            //
            Vector	params = new Vector(5);

            // params.insertElementAt("ncsa.sql.driver.Driver", 0);
            // params.insertElementAt("jdbc:decibel/usr/tmp/dbRoot", 1);
            // params.insertElementAt("ignore", 2);
            // params.insertElementAt("ignore", 3);

            try {
                rep.setConfig(params);
            } catch (ServiceNotFoundException e) {
                System.err.println("Cannot configure JDBC");
                e.printStackTrace();
                System.exit(1);
            }

            Debug.println("Repository configuration done");

            cmf    = new Framework((MoRepSrvIf)rep, null);
            domain = cmf.getDomain();

            Debug.println("Got domain = " + domain);

            //
            // See if we already have a MetaDataService in case of
            // persistent repository.
            //
            try {
                mtdSrv = cmf.getMetaDataSrvIf();
                if (mtdSrv == null) {
                    Debug.println("Metadata service not found, " +
                                  "adding " + mtdName);

                    cmf.newObject(mtdName, domain + ":" + ServiceName.META, null);
                }
                else {
                    Debug.println("Found a metadata service.");
                    cmf.setMetaDataSrvIf(mtdSrv);
                }
            } catch (IllegalAccessException e) {
                System.err.println("Cannot check for metadata service");
                e.printStackTrace();
            } catch (ServiceNotFoundException e) {
                System.err.println("Cannot check for metadata service");
                e.printStackTrace();
            }

            //
            // Add the RMI adaptor service
            //
            String rmiName= new String(domain + ":" + ServiceName.ADAPTOR + ".protocol=rmi,port=1099");
            Debug.println("Adding " + adpNameRmi + " to CMF with name \n\t" + rmiName);
            cmf.newObject(adpNameRmi, rmiName, null);

            //
            // Add the HTML adaptor service.
            //
            String htmlName= new String(domain + ":" + ServiceName.ADAPTOR + ".protocol=html,port=8082");
            Debug.println("Adding " + adpNameHtml + " to CMF with name \n\t" + htmlName);
            cmf.newObject(adpNameHtml, htmlName, null);
        } catch (Exception e) {
            e.printStackTrace();
        }

        //
        // Add the filtering service to the framework
        //
        try {
            cmf.newObject("com.sun.jaw.impl.agent.services.light.FilterSrv",
                          domain + ":" +ServiceName.FILTER, null);
        } catch(Exception e) {
            System.out.println("Problem adding the filtering service "+domain + ":" +ServiceName.FILTER);
            e.printStackTrace();
            System.exit(-1);
        }

        //
        // Get the classes for which MBeans are to be created
        //
        String[] classes;
        if (args.length == 0) {
            classes = new String[4];
            classes[0] = "java.lang.Object";
            classes[1] = "java.lang.String";
            classes[2] = "java.util.Vector";
            classes[3] = "java.io.File";
        }
        else {
            classes = args;
        }

        //
        // Create the Class MBeans
        //
        int iclass;
        for (iclass = 0; iclass < classes.length; iclass++) {
            ClassMB cl = new ClassMB(classes[iclass]);
            try {
                cmf.newObject(cl.getClass().getName(), cl.objectName(), null);
            } catch(Exception e) {
                System.out.println("Problem creating class MBean for "+cl.getClass().getName());
                e.printStackTrace();
                System.exit(-1);
            }
        }
    
        //
        // Do the queries
        //
        Agent.doQueries(cmf);
    }

    private static void doQueries(Framework cmf) {
        //
        // Apply the queries to our objects
        //
        QueryExp aQry;
        for (int i = 1; (aQry = Queries.query(i)) != null; i++) {

            System.out.print("\nGetting objects that validate the following query :\n\t");
            System.out.println(aQry);
            System.out.println();

            Vector objs = null;
            try {
                objs = cmf.getObject(new ObjectName(":"), aQry);
            } catch(Exception e) {
                System.out.println("Problem getting objects");
                e.printStackTrace();
                System.out.println();
                System.out.println();
            }
      
            if (objs == null  || objs.size() == 0) {
                System.out.println("No match");
            }
            else {
                for (Enumeration e = objs.elements(); e.hasMoreElements(); ) {
                    NamedObject no = (NamedObject) e.nextElement();
                    System.out.println("\t"+no.getName());
                }
            }
        }
    }
}
