// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)KernelStat.java 1.2 99/03/12 SMI"

/**
 * The "kstat" example runs only on machines with Solaris Os.
 *
 * This class contains the JNI interface for Kernel Statistics based on the Solaris 
 * kstat(3M) interface. 
 * <p>
 * The native library implementing the native methods is <b>libstat.so</b> provided under:
 * <p>
 * <CODE>SUNWconn/jaw/lib/Solaris/sparc/2.x/lib/libstat.so</CODE>
 *
 * @version     1.2     03/12/99
 * @author      Sun Microsystems, Inc
 */ 
public class KernelStat {
    
    private String moduleName;
    private String instanceName;
  
    public static final int STAT_RAW   = 0;
    public static final int STAT_NAMED = 1;
    public static final int STAT_INTR  = 2;
    public static final int STAT_IO    = 3;
    public static final int STAT_TIMER = 4;

    public native String statGetList(String module, String instance, int type);
    public native String statGetValue(String module, String instance, String property);
    public native String statProperties(String module, String instance);
    public native int    statType(String module, String instance);

    //
    // Constructors
    //
    public KernelStat() {
        moduleName   = null;
        instanceName = null;
        System.loadLibrary("stat");
    }
  
    public KernelStat(String mod, String inst) {
        moduleName   = mod;
        instanceName = inst;
        System.loadLibrary("stat");
    }
  
    public Integer statGetIntegerValue(String propName) {
        String strValue= null;
        try {
            strValue = statGetValue(moduleName, instanceName, propName);
        } catch (Exception e) {
            System.out.println("statGetValue throws exception");
            e.printStackTrace();
        }
    
        if (strValue != null) {
            try {
                return (new Integer(strValue));
            } catch (NumberFormatException e) {
                return (new Integer(-1));
            }
        }
    
        return (new Integer(-1));
    }
  
    public Long statGetLongValue(String propName) {
        String strValue = statGetValue(moduleName, instanceName, propName);

        if (strValue != null) {
            try {
                return (new Long(strValue));
            } catch (NumberFormatException e) {
                return (new Long(-1));
            }
        }
    
        return (new Long(-1));
    } 
}
