// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)SimpleEvent.java 3.3 99/03/12 SMI"

import java.util.EventObject;

/**
 * A simple definition of an EventObject object.
 * This event is fired by the Simple M-bean.
 *
 * @version     3.3     03/12/99
 * @author      Sun Microsystems, Inc
 */

public class SimpleEvent extends EventObject {
  
    /**
     * Create a simpleEvent object. The source of the event
     * as well as the value of the "NbChanges" property needs
     * to be specified.
     */
    public SimpleEvent(Simple source, Integer val) {
        super(source);
        nbChanges= val;
    }

    /**
     * Returns the value of "NbChanges" property as 
     * given when the event object was created.
     */
    public Integer getNbChanges() {
        return nbChanges;
    }
  
    /**
     * Returns the version of this class.
     */
    public String getClassVersion() {
        return (sccs_id);
    }


    /**
     * Number of changes
     */
    private Integer	nbChanges;
  
    /**
     * Version of the implementation
     */
    private static final String sccs_id = "@(#)SimpleEvent.java 3.3 03/12/99 SMI";
}
