// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)Simple.java 3.3 99/03/12 SMI"

import java.util.*;

/**
 * Simple definition of a m-bean.
 * The m-bean shows how to:
 *      - implement events in an m-bean
 *      - emmit events of type SimpleEvent each time the "State" property is modified
 *      - register a Simple listener with the m-bean to receive events
 *
 * The object has three properties:
 *      - "State" a read/write property
 *      - "ClassVersion" a read only property that keeps the version of this implementation
 *      - "NbChanges" a read only property
 *
 * @see  SimpleEvent
 * @see  SimpleListener
 *
 * @version     3.3     03/12/99
 * @author      Sun Microsystems, Inc
 */

public class Simple implements java.io.Serializable {

    /**
     * Getter for the "ClassVersion" property. The method
     * is compliant with the Bean design pattern.
     *
     * @return the current value of the "tClassVersion" property 
     */
    public String getClassVersion() {
        return sccs_id;
    }

    /**
     * Getter for the "State" property. The method
     * is compliant with the Bean design pattern.
     *
     * @return the current value of the "State" property.
     */
    public String getState() {
        return state;
    }

    /**
     * Getter for the "State" property. The method
     * is compliant with the Bean design pattern.
     * Each time the method is called, a SimpleEvent
     * will be sent to all the listeners that implements the
     * SimpleListener interface and which is at the time registered with the m-bean.
     *
     * @return the current value of the "State" property.
     */
    public void setState(String s) {
        state = s;
        nbChanges++;
    
        // Send an event !
        //
        SimpleEvent event= new SimpleEvent(this, new Integer(nbChanges));
        deliverChange(event);
    }

    /**
     * Getter for the "NbChanges" property.The method
     * is compliant with the Bean design pattern.
     *
     * @return the current value of the "NbChanges" property.
     */
    public Integer getNbChanges() {
        return new Integer(nbChanges);
    }
  
    /**
     * Register a listener for receiving SimpleEvents events.
     * The method is compliant with the Bean design pattern.
     *
     * @param x the listener to add.
     */
    public synchronized void addSimpleListener(SimpleListener x)  {
        simpleListeners.addElement(x);
    }

    /**
     * Remove a listener.
     *
     * @param x the listener to remove.
     *
     */
    public synchronized void removeSimpleListener(SimpleListener x) {
        simpleListeners.removeElement(x);
    }
  
    /**
     * Send an event to all the registered listeners.
     *
     * @param event the event to emmit.
     *
     */
    private void deliverChange(SimpleEvent event) {
    
        // Make a local (frozen) copy of the list of the current list of
        // removeSimpleListener.  If there are no listeners, we're done.
        //
        Vector l;
        int n;
 
        synchronized (this)
            {
                l = (Vector)simpleListeners.clone();
                n = l.size();
                if (n == 0) return;
            }
 
        Vector symbols = new Vector();
        for(int i = 0; i < l.size(); i++) {
            SimpleListener simpleListener = (SimpleListener)l.elementAt(i);
            simpleListener.handleEvent1(event);
        }

    }


    // M-bean properties.
    //
    private String        state = "initial state";
    private int       	nbChanges = 0;
    private static final String sccs_id = "@(#)Simple.java 3.3 03/12/99 SMI";

    // Private variables.
    //
    private Vector simpleListeners = new Vector();
}
