// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)ClientListener.java 3.3 99/03/12 SMI"

// java import
//
import java.util.*;

// jaw import
//
import com.sun.jaw.reference.common.*;
import com.sun.jaw.reference.client.mo.*;

/**
 * A simple event listener for receiving SimpleEvent events.
 * An event listener class must always be declared public.
 * The application shows how to:
 *      - use the event mechanism
 *      - implement the SimpleListenerMO interface to receive events of type SimpleEvent
 *
 * @see  SimpleEventMO
 * @see  SimpleListenerMO
 * @see  SimpleMO
 *
 * @version     3.3     03/12/99
 * @author      Sun Microsystems, Inc
 */

public class ClientListener implements SimpleListenerMO {

    public ClientListener() {
        super();
    }

    public void handleEvent1(SimpleEventMO event) {
        System.out.println("\nClientListener::handleEvent1 -> Received an event !");
        System.out.println(">>> Event Status:");
        System.out.println("event.NbChanges		= " + event.getNbChanges());
        System.out.println("event.ClassVersion	= " +  event.getClassVersion());
    }

    public void handleEvent2(SimpleEventMO event) {
        System.out.println("\nClientListener::handleEvent2 -> Received an event !");
        System.out.println(">>> Event Status:");
        System.out.println("event.NbChanges		= " + event.getNbChanges());
        System.out.println("event.ClassVersion	= " +  event.getClassVersion());
    }
  
    public String getClassOfAgentListener() {
        return classOfAgentListener;
    }

    public String getClassOfAgentEvent() {
        return classOfAgentEvent; 
    }

    public String getClassOfEventMO() {
        return classOfEventMO;
    }


    // Private variables.
    //
    private static String classOfAgentListener= "SimpleListenerStub";

    private static String classOfAgentEvent= "SimpleEvent";
    private static String classOfEventMO= "SimpleEventMO";

}
