// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)Client.java 3.3 99/03/12 SMI"

import java.net.* ;
import java.util.* ;
import com.sun.jaw.reference.common.* ;
import com.sun.jaw.impl.adaptor.rmi.* ;

/**
 * The Client implements a simple management application.
 * 
 * The application shows how to:
 *      - set up communictaion using the RMI client adaptor
 *      - instantiate an m-bean in a remote agent
 *      - register a Simple listener with the Simple m-bean to recieve events of type SimpleEvent
 *      - access properties of a remote m-bean
 *      - remove a listener from the Simple m-bean
 *      - remove an m-bean from the remote agent
 * 
 * Prior to starting the client application, make sure an agent is running.
 *
 * @see  SimpleEventMO
 * @see  SimpleListenerMO
 * @see  SimpleMO
 *
 * @version     3.3     03/12/99 
 * @author      Sun Microsystems, Inc
 *
 */

public class Client implements Runnable {

    // CONSTRUCTOR
    //------------
    public Client() {
    }
  
    /**
     * It is possible to specify on the command line the implementation to use
     * for the adaptor function. 
     */
    public static void main(String argv[]) {
	
        System.exit( new Client().execute(argv) ) ;
    }
  
    /**
     * When an object implementing interface Runnable is used to create a thread, 
     * starting the thread causes the object's run method to be called in that
     * separately executing thread.
     */
    public void run() {
	
        String[] s = new String[0];
        execute(s);
    }
  
  
    // PRIVATE METHODS
    //----------------
    private int execute(String argv[]) {
	
        try {
            // Set the host name of the remote object server.
            //
            String agentHost = InetAddress.getLocalHost().getHostName();
            if (argv.length >= 1) 
                agentHost = argv[0];

            // Set the port number of the remote host.
            //
            int agentPort = 1099;
            if (argv.length >= 2) 
                agentPort = Integer.decode(argv[1]).intValue();

            System.out.println(">>> Connecting to " + agentHost + " using port number " + agentPort);

            // Set up the RMI AdaptorClient. 
            //
            AdaptorClient adaptor = new AdaptorClient();

            // Initialize communication with the remote RMI object server.
            //
            adaptor.connect(null, agentHost, agentPort, ServiceName.APT_RMI);

            // Get the domain name from the object server.
            //
            String domain = adaptor.getDomain();

            // Creates an instance of the Simple m-bean in the 
            // remote object server.
            //
            String simpleClass = "Simple";
            ObjectName simpleName = new ObjectName(domain + ":SimpleMO.id=1");
            System.out.println("\nCreate an instance of Simple in the remote object server");
            System.out.println("with the object name -> " + simpleName.toString());
            SimpleMO simple = (SimpleMO) adaptor.cb_newMO(simpleClass, simpleName, null);
            System.out.println("Creation ok\n");
      
            // Create an event listener.
            // 
            ClientListener listener= new ClientListener();
 
            // Register a listener with the remote event source.
            // 
            simple.addSimpleListenerMO(listener);

            // Access and modify the properties of the Simple
            // m-bean remotely.
            // This should triger an event.
            //
            System.out.println("\n>>> Initial state...");
            System.out.println("simple.state     = " + simple.getState());
            System.out.println("simple.nbChanges = " + simple.getNbChanges());

            System.out.println("\n>>> Changing state... <We should receive an event>");
            simple.setState("New state");

            // Wait before cleaning up and terminate.
            // 
            System.out.println("\nPress <Enter> to clean up and terminate...");
            System.in.read();

            // Remove the listener from the event source.
            // 
            System.out.println("\nRemoving listener");
            simple.removeSimpleListenerMO(listener);
            System.out.println("Removal ok");

            // Deletes an instance of the Simple m-bean in the 
            // remote object server.
            //
            System.out.println("\nDelete an instance of Simple in the remote object server");
            System.out.println("with the object name -> " + simpleName.toString());
            adaptor.deleteMO(simpleName);
            System.out.println("Deletion ok\n");
      
            // Terminate communication with the remote object server.
            //
            adaptor.disconnect();
            //System.exit(0);
            return 0;
        }
        catch(Exception e) {
            System.out.println("Got an exception !");
            e.printStackTrace();
            //System.exit(1);
            return 1;
        }
    }
}
