// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)Simple.java 3.3 99/03/12 SMI"

/**
 * Very simple definition of a m-bean.
 * The m-bean shows how to:
 *      - access properties via getter and setter methods
 *      - perform an action
 *
 * The object has two properties:
 *      - "State" a read/write property
 *      - "NbChanges" a read only property
 */

public class Simple implements java.io.Serializable {

    /**
     * Getter for the "State" property. The method
     * is compliant with the Bean design pattern.
     *
     * @return the current value of the "State" property.
     */
    public String getState() {
        return state;
    }

    /** 
     * Setter for the "State" property. The method is 
     * compliant with the Bean design pattern.
     *
     * @param <VAR>s</VAR> the new value of the property.
     */
    public void setState(String s) {
        state = s;
        nbChanges++;
    }

    /**
     * Getter for the "NbChanges" property. The method
     * is compliant with the Bean design pattern.
     *
     * @return the current value of the "NbChanges" property.
     */
    public Integer getNbChanges() {
        return new Integer(nbChanges);
    }

    /**
     * Resetter for the "NbChanges" property.
     */
    public void performReset() {
        nbChanges = 0;
    }

    // M-bean properties.
    //
    private String        state = "initial state";
    private int           nbChanges = 0;
}
