// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)SelfRegClient.java 3.3 99/03/12 SMI"

import java.net.* ;
import java.util.* ;
import com.sun.jaw.reference.common.* ;
import com.sun.jaw.impl.adaptor.rmi.* ;

/**
 * The SelfRegClient implements a simple management application.
 * 
 * The application shows how to:
 *      - set up communictaion using the RMI client adaptor
 *      - instantiate an m-bean in a remote agent
 *      - access and modify properties of a remote m-bean
 *      - remove an m-bean from the remote agent
 * 
 * Prior to starting the client application, make sure an agent is running.
 *
 * @version     3.3     03/12/99 
 * @author      Sun Microsystems, Inc
 *
 * @see com.sun.jaw.impl.adaptor.rmi.AdaptorClient
 * @see com.sun.jaw.impl.base.Main
 */

public class SelfRegClient implements Runnable {

    // CONSTRUCTOR
    //------------
    public SelfRegClient() {
    }

    /**
     * It is possible to specify on the command line the implementation to use
     * for the adaptor function. 
     */
    public static void main(String argv[]) {
	
        System.exit( new SelfRegClient().execute(argv) ) ;	
    }
  
    /**
     * When an object implementing interface Runnable is used to create a thread, 
     * starting the thread causes the object's run method to be called in that
     * separately executing thread.
     */
    public void run() {
	
        String[] s = new String[0];
        execute(s);
    }
  
  
    // PRIVATE METHODS
    //----------------
    private int execute(String argv[]) {
	
        try {
            // Set the host name of the remote object server.
            //
            String agentHost = InetAddress.getLocalHost().getHostName();
            if (argv.length >= 1)
                agentHost = argv[0];

            // Set the port number of the remote host.
            //
            int agentPort = 1099;
            if (argv.length >= 2)
                agentPort = Integer.decode(argv[1]).intValue();

            System.out.println(">>> Connecting to " + agentHost + " using port number " + agentPort);

            // Set up the RMI AdaptorClient. 
            //
            AdaptorClient adaptor = new AdaptorClient();

            // Initialize communication with the remote RMI object server.
            //
            adaptor.connect(null, agentHost, agentPort, ServiceName.APT_RMI);

            // Get the domain name from the object server.
            //
            String domain = adaptor.getDomain();

            // Creates an instance of SelfRegBean in the 
            // remote object server.
            //
            String selfRegClass = "SelfRegBean";
            ObjectName selfRegName = new ObjectName(domain + ":SelfRegBean.id=1");
            System.out.println("\nCreate an instance of SelfRegBean in the remote object server");
            System.out.println("with the object name -> " + selfRegName.toString());
            SelfRegBeanMO selfreg = (SelfRegBeanMO) adaptor.cb_newMO(selfRegClass, selfRegName, null);
            System.out.println("Creation ok\n");
      
            // Access and modify the properties of the SelfRegBean 
            // m-bean remotely.
            //
            System.out.println("\n>>> Initial state...");
            System.out.println("selfreg.state     = " + selfreg.getState());
            System.out.println("selfreg.nbChanges = " + selfreg.getNbChanges());

            System.out.println("\n>>> Changing state...");
            selfreg.setState("New state");

            System.out.println("selfreg.state     = " + selfreg.getState());
            System.out.println("selfreg.nbChanges = " + selfreg.getNbChanges());

            System.out.println("\n>>> Resetting change counters...");
            selfreg.performReset();
      
            System.out.println("selfreg.state     = " + selfreg.getState());
            System.out.println("selfreg.nbChanges = " + selfreg.getNbChanges() + "\n");

            // Deletes an instance of SelfRegBean in the 
            // remote object server.
            //
            System.out.println("Delete an instance of SelfRegBean in the remote object server");
            System.out.println("with the object name -> " + selfRegName.toString());
            adaptor.deleteMO(selfRegName);
            System.out.println("Deletion ok\n");
      
            // Terminate communication with the remote object server.
            //
            adaptor.disconnect();
            //System.exit(0);
            return 0;
        }
        catch(Exception e) {
            System.out.println("Got an exception !");
            e.printStackTrace();
            //System.exit(1);
            return 1;
        }
    }
}
