// Copyright (c) 03/24/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)SelfRegBean.java 3.5 99/03/24 SMI"

// java import
//
import java.io.*;
import java.lang.*;
import java.util.*;

// jaw import
//
import com.sun.jaw.reference.query.*;
import com.sun.jaw.reference.common.*;
import com.sun.jaw.reference.agent.cmf.*;
import com.sun.jaw.impl.common.DefaultPaths;
import com.sun.jaw.impl.agent.services.loader.rmi.*;

/**
 * A simple definition of an m-bean.
 * The m-bean shows how to:
 *      - use the initCmf method to register the m-bean
 *      - use the deleteCmf method to serialize the m-bean
 *
 * The object has two properties:
 *      - "State" a read/write property
 *      - "NbChanges" a read only property
 */

public class SelfRegBean implements java.io.Serializable {

    /**
     * Getter for the "State" property. The method
     * is compliant with the Bean design pattern.
     *
     * @return the current value of the "State" property.
     */
    public String getState() {
        return state;
    }

    /** 
     * Setter for the "State" property. The method is 
     * compliant with the Bean design pattern.
     *
     * @param <VAR>s</VAR> the new value of the property.
     */
    public void setState(String s) {
        state = s;
        nbChanges++; 
    }

    /**
     * Getter for the "NbChanges" property. The method
     * is compliant with the Bean design pattern.
     *
     * @return the current value of the "NbChanges" property.
     */
    public Integer getNbChanges() {
        return new Integer(nbChanges);
    }

    /**
     * Resetter for the "NbChanges" property.
     */
    public void performReset(){
        nbChanges = 0; 
    }

    /**
     * Perform initialization tasks and register the m-bean.
     *
     * @param	agent  a reference to the core management framework.
     * @param	name   the object name to use for registering.
     *
     * @exception java.lang.IllegalAccessException 
     *		The method cannot access the class definition of the specified m-bean.
     * @exception com.sun.jaw.reference.common.ServiceNotFoundException
     *		The requested service is not supported.
     * @exception com.sun.jaw.reference.common.InstanceAlreadyExistException 
     *		The m-bean is already registered in the repository.
     * @exception IllegalArgumentException 
     *		One of the parameters in the call to the method is invalid.
     */
    public void initCmf(Framework agent, ObjectName name, boolean db, ModificationList list)
        throws InstanceAlreadyExistException {

        // Creates an ObjectName if it was not given.
        // NOTE:
        //	The ObjectName can be null if the request was made
        // 	throught the M-Let service.
        //
        if (name == null)
            name = new ObjectName(agent.getDomain(),this.getClass().getName(),key,value);

        // Adds a named m-bean under the control of the core management framework. 
        //
        System.out.println("\nSelfRegBean: Register with object name -> " + name.toString());
        if (db) {
            agent.addDBObject(this, name);
        } else {
    	    agent.addObject(this, name);
        }
        System.out.println("SelfRegBean: Registeration ok\n");
    }

    /**
     * Perform closedown tasks. In this example we serialize the m-bean on closedown.
     */
    public void deleteCmf() {

        // Serialize the object before closing down.
        //
        try {
            // Default directory: /opt/SUNWconn/jaw/tmp (Solaris) or <installDir>\SUNWconn\jaw\tmp (Windows NT).
            //
            String path = DefaultPaths.getTmpDir();
            File outputDir = new File(path, name);
            System.out.println("\nSelfRegBean: Serialize in -> " + outputDir.toString());
            FileOutputStream ostream = new FileOutputStream(outputDir);
            ObjectOutputStream objstream = new ObjectOutputStream(ostream);
            objstream.writeObject(this);
            objstream.flush();
            ostream.close();
            System.out.println("SelfRegBean: Serialization ok\n");
        } catch (IOException e) {
            System.out.println("SelfRegBean: Could not serialize -> " + e.getMessage() + "\n");
        }
    }

    // M-bean properties.
    //
    private String	state = "initial state";
    private int		nbChanges = 0;

    // Private variables
    //
    private String	name = "SelfRegBean.ser";
    private String	key = "id";
    private Integer	value = new Integer(1);
}
