// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)Client.java 3.3 99/03/12 SMI"

import java.util.*;
import java.net.*;

// jaw import
//
import com.sun.jaw.reference.common.*;
import com.sun.jaw.impl.adaptor.rmi.* ;

/**
 * The Client implements a simple management application.
 *
 * Prior to starting the client application, make sure an agent is running.
 *
 * @version     3.3     03/12/99
 * @author      Sun Microsystems, Inc
 */


public class Client implements Runnable {
  
    // CONSTRUCTOR
    //------------
    public Client() {
    }

    /**
     * It is possible to specify on the command line the implementation to use
     * for the adaptor function. 
     */
    public static void main(String argv[]) {
	
        System.exit( new Client().execute(argv) ) ;	
    }
  
    /**
     * When an object implementing interface Runnable is used to create a thread, 
     * starting the thread causes the object's run method to be called in that
     * separately executing thread.
     */
    public void run() {
	
        String[] s = new String[0];
        execute(s);
    }
  
  
    // PRIVATE METHODS
    //----------------
    private int execute(String argv[]) {
	
        try {
            // Set the host name of the remote object server.
            //
            String agentHost = InetAddress.getLocalHost().getHostName();
            if (argv.length >= 1) 
                agentHost = argv[0];

            // Set the port number of the remote host.
            //
            int agentPort = 1099;
            if (argv.length >= 2) 
                agentPort = Integer.decode(argv[1]).intValue();

            System.out.println(">>> Connecting to " + agentHost + " using port number " + agentPort);

            // Set up the RMI AdaptorClient. 
            //
            AdaptorClient adaptor = new AdaptorClient();

            // Initialize communication with the remote RMI object server.
            //
            adaptor.connect(null, agentHost, agentPort, ServiceName.APT_RMI);
	  
            // Get the domain name of the server.
            //
            String domain = adaptor.getDomain();
	  
            // Creates an instance of Season in the remote object server.
            //
            String seasonClass = new String("Season");
            ObjectName seasonName = new ObjectName(domain + ":" + seasonClass + "MO.id=1");
            System.out.println("\nCreate an instance of Season in the remote object server");
            System.out.println("with the object name -> " + seasonName.toString());
            SeasonMO season = (SeasonMO)adaptor.cb_newMO(seasonClass, seasonName, null);
            System.out.println("Creation of the Season object ok\n");
	  
            // Access the properties of the Season m-bean remotely.
            //
            System.out.println(">>> Initial state...");
            System.out.println("\tNumberOfEvents= " + season.getNumberOfEvents());
            if (season.isActive())
                System.out.println("\tThe scheduler is active...");
            else
                System.out.println("\tThe scheduler is not active...");
	  
            // Starts the scheduler service.
            //
            System.out.println("\n>>> Start the scheduler service...");
            season.performStartScheduler();
            System.out.println("\tNumberOfEvents= " + season.getNumberOfEvents());
            if (season.isActive())
                System.out.println("\tThe scheduler is active...");
            else
                System.out.println("\tThe scheduler is not active...");

            // Wait before cleaning up and terminate
            // 
            System.out.println("\nPress <Enter> to clean up and terminate...");
            System.in.read();
	  
            // Stops the scheduler service.
            //
            System.out.println("\n>>> Stop the scheduler service...");
            season.performStopScheduler();
            System.out.println("\tNumberOfEvents= " + season.getNumberOfEvents());
            if (season.isActive())
                System.out.println("\tThe scheduler is active...");
            else
                System.out.println("\tThe scheduler is not active...");
      
            // Deletes an instance of Season in the remote object server.
            //
            System.out.println("\nDelete an instance of Season in the remote object server");
            System.out.println("with the object name -> " + seasonName.toString());
            adaptor.deleteMO(seasonName);
            System.out.println("Deletion ok\n");
	  
            // Terminate communication with the remote object server.
            //
            adaptor.disconnect();
            return 0;
        }
        catch(Exception e) {
            Debug.printException(e);
            e.printStackTrace();
            return 1;
        }
    }
}
