// Copyright (C) 03/12/99, By Sun Microsystems, Inc.
// All Rights Reserved.

// "@(#)ClientListener.java 3.3 99/03/12 smi"

// java import
//
import java.util.*;

// jaw import
//
import com.sun.jaw.reference.common.*;
import com.sun.jaw.impl.agent.services.monitor.*;

/**
 * A simple monitor event listener for receiving monitor events.
 *
 * The application shows how to:
 *      - implement the MonitorListenerMO interface to receive events of type MonitorEvent
 *
 * @see  com.sun.jaw.impl.agent.services.monitor.MonitorEvent
 * @see  com.sun.jaw.impl.agent.services.monitor.MonitorlistenerMO 
 *
 * @version     1.1     10/10/97
 * @author      Sun Microsystems, Inc
 */

public class ClientListener implements MonitorListenerMO {

    public ClientListener() {
        super();
    }


    public void handleMonitor(MonitorEventMO event) {
        // Get a handle on the monitor responsable for the event
        // emmited.
        MonitorMO Monitor = (MonitorMO) event.getSource();
    
        // Process the different types of events fired by the monitors.
        //
        try {
            switch (event.getMonitorEventType().intValue()) {
            case MonitorEvent.GRANULARITY_PERIOD_EVT:
                System.out.println("\nClientlistener: Monitor event -> Granularity Period is negative or zero");
		
                // Set the monitor'S administrative state to off.
                //
                System.out.println("Clientlistener: Deactivates the Monitor service\n");
                Monitor.performStop();
            case MonitorEvent.OBSERVED_OBJECT_EVT:
                System.out.println("\nClientlistener: Monitor event -> " + event.getMonitorEventObservedObject().getClass().getName() + " is not registered in the cmf");
		
                // Set the monitor'S administrative state to off.
                //
                System.out.println("Clientlistener: Deactivates the Monitor service\n");
                Monitor.performStop();
                break;
            case MonitorEvent.OBSERVED_PROPERTY_EVT:
                System.out.println("\nClientlistener: Monitor event -> " + event.getMonitorEventObservedProperty() + " Property is not contained in " + event.getMonitorEventObservedObject().getClass().getName());
                // Set the monitor'S administrative state to off.
                //
                System.out.println("Clientlistener: Deactivates the Monitor service\n");
                Monitor.performStop();
                break;
            case MonitorEvent.OBSERVED_PROPERTY_TYPE_EVT:
                System.out.println("\nClientlistener: Monitor event -> Type of " + event.getMonitorEventObservedProperty() + " Property is not correct");
		
                // Set the monitor'S administrative state to off.
                //
                System.out.println("Clientlistener: Deactivates the Monitor service\n");
                Monitor.performStop();
            case MonitorEvent.THRESHIGH_LOWER_THAN_THRESLOW_EVT:
                System.out.println("\nClientlistener: Monitor event -> Threshold High Value Is Less Than Threshold Low Value");     
		
                // Set the monitor'S administrative state to off.
                //
                System.out.println("Clientlistener: Deactivates the Monitor service\n");
                Monitor.performStop();
                break;
            case MonitorEvent.THRESHOLD_HIGH_VALUE_EXCEEDED_EVT:
                System.out.println("\nClientlistener: Monitor event -> " + event.getMonitorEventObservedProperty() + " Has Exceeded The Threshold High >> Value = " + event.getMonitorEventDerivedGauge()); 
                System.out.println("Clientlistener: TEMP ALERT !! Temperature rise >= 10 degrees"); 
                break;
            case MonitorEvent.THRESHOLD_LOW_VALUE_EXCEEDED_EVT:
                System.out.println("\nClientlistener: Monitor event -> " + event.getMonitorEventObservedProperty() + " Has Exceeded The Threshold Low >> Value = " + event.getMonitorEventDerivedGauge());
                System.out.println("Clientlistener: TEMP ALERT !! Temperature drop <= 10 degrees"); 
                break;
            case MonitorEvent.THRESHOLD_TYPE_EVT:
                System.out.println("\nClientlistener: Monitor event -> Threshold High And Threshold Low Are Not Of The Same Type"); 
		
                // Set the monitor'S administrative state to off.
                //
                System.out.println("Clientlistener: Deactivates the Monitor service\n");
                Monitor.performStop();
            default:
                System.out.println("\nClientlistener: Unknown event Type (?)");
            }
        } catch (Exception e) {
            System.out.println("Got An Exception !");
            System.out.println(e);
        }
    }

}
