// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)Client.java 3.3 99/03/12 SMI"

import java.net.* ;
import java.util.* ;

// jaw import
//
import com.sun.jaw.reference.common.* ;
import com.sun.jaw.impl.adaptor.rmi.* ;
import com.sun.jaw.impl.agent.services.monitor.*;

/**
 * The Client implements a simple management application.
 * The example shows how the gauge monitor can be used to observe the
 * differences in property values of a specific m-beans properties and 
 * receive events according to changes in the observed gauge values for
 * two successive observations.
 *
 * Prior to starting the client application, make sure an agent is running.
 *
 * @version     3.3     03/12/99 
 * @author      Sun Microsystems, Inc
 *
 * @see com.sun.jaw.impl.adaptor.rmi.AdaptorClient
 * @see com.sun.jaw.impl.base.Main
 */

public class Client implements Runnable {

    // CONSTRUCTOR
    //------------

    public Client() {
    }
  
    /**
     * It is possible to specify on the command line the implementation to use
     * for the adaptor function. 
     */
    public static void main(String argv[]) {
	
        System.exit( new Client().execute(argv) ) ;	
    }
  
    /**
     * When an object implementing interface Runnable is used to create a thread, 
     * starting the thread causes the object's run method to be called in that
     * separately executing thread.
     */
    public void run() {
	
        String[] s = new String[0];
        execute(s);
    }
  
  
    // PRIVATE METHODS
    //----------------

    private int execute(String argv[]) {
	
        try {
            // Set the host name of the remote agent.
            //
            String agentHost = InetAddress.getLocalHost().getHostName();
            if (argv.length >= 1) {
                agentHost = argv[0];
            }

            // Set the port number of the remote host.
            //
            int agentPort = 1099;
            if (argv.length >= 2) {
                agentPort = Integer.decode(argv[1]).intValue();
            }

            // Create an adaptor client to enable the client to manage the remote agent
            // and initializes the communications with the remote agent.
            //
            trace(">>> CREATE and INITIALIZE communication with the remote agent,");
            trace("HOST     = " + agentHost);
            trace("PORT     = " + agentPort);
            trace("PROTOCOL = RMI");
            trace("SERVER   = " + ServiceName.APT_RMI);
            AdaptorClient adaptor = new AdaptorClient();
            adaptor.connect(null, agentHost, agentPort, ServiceName.APT_RMI);
            trace("Communication ok\n");


            // Get the domain name from the remote agent.
            //
            String domain = adaptor.getDomain();

            // Instanciate the listener.
            //
            ClientListener listen = new ClientListener();

            // Creates an instance of the Weather m-bean in the 
            // remote agent.
            //
            String weatherClass = "Weather";
            ObjectName weatherName = new ObjectName(domain + ":WeatherMO.id=1");
            trace(">>> CREATE an instance of an m-bean in the remote agent,");
            trace("M-BEAN      = " + weatherClass);
            trace("OBJECT NAME = " + weatherName);
            WeatherMO weather = (WeatherMO) adaptor.cb_newMO(weatherClass, weatherName, null);
            trace("Creation ok\n");
      
            // Access the properties of the Weather m-bean remotely
            // and get the initial property values.
            //
            trace(">>> GET the initial property values of an m-bean from the remote agent,");
            trace("OBJECT NAME = " + weatherName);
            trace("PROPERTY \"Temp\"  = " + weather.getTemp());
            trace("PROPERTY \"State\" = " + weather.getState());
            trace("Get ok\n");
      
            // Create a gauge monitor object.
            //
            String tempMonitorClass = "com.sun.jaw.impl.agent.services.monitor.GaugeMonitor";
            ObjectName tempMonitorName = new ObjectName(domain + ":" + tempMonitorClass + ".id=Temp");
            trace(">>> CREATE an instance of a gauge monitor in the remote agent,");
            trace("M-BEAN      =" + tempMonitorClass);
            trace("OBJECT NAME = " + tempMonitorName);
            GaugeMonitorMO tempMonitor = (GaugeMonitorMO) adaptor.cb_newMO(tempMonitorClass, tempMonitorName, null);
            trace("Creation ok\n");
 
            // Threshold values for gauge monitor.
            //
            Float tempHigh = new Float(10);
            Float tempLow = new Float(-10);

            // Set the values of the gauge monitor object.
            // The gauge monitor will check every 5 seconds the value of the
            // difference between the current "Temp" property value and the 
            // previous "Temp" property value for the Weather m-bean.
            // A threshold high monitor event will be emited if the difference
            // value reached or exceeded the high threshold value.
            // A threshold low monitor event will be emited if the difference
            // value reached or fell below the low threshold value.
            // NOTE: The guage monitor works with oscillations. If the observed
            //       value reached or exceeded the high threshold the next event
            //       should be for a value that reached or fell below the low threshold.
            //       This means you can't get two threshold high or two threshold low
            //       events after each other.
            //
            trace(">>> SET the property values of the gauge monitor,");
      
            trace("PROPERTY \"ObservedObject\"       = " + weatherName);
            tempMonitor.setObservedObject(weatherName);
      
            trace("PROPERTY \"ObservedProperty\"     = Temp");
            tempMonitor.setObservedProperty("Temp");
      
            trace("PROPERTY \"GaugeDifferenceOnOff\" = true");
            tempMonitor.setGaugeDifferenceOnOff(Boolean.TRUE);
      
            trace("PROPERTY \"NotifyLowOnOff\"       = true");
            tempMonitor.setNotifyLowOnOff(Boolean.TRUE);

            trace("PROPERTY \"NotifyHighOnOff\"      = true");
            tempMonitor.setNotifyHighOnOff(Boolean.TRUE);

            trace("PROPERTY \"ThresholdLowValue\"    = " + tempLow);
            tempMonitor.setThresholdLowValue(tempLow);

            trace("PROPERTY \"ThresholdHighValue\"   = " + tempHigh);
            tempMonitor.setThresholdHighValue(tempHigh);
      
            trace("PROPERTY \"GranularityPeriod\"    = 5 seconds");
            tempMonitor.setGranularityPeriod(new Integer(5000));
      
            tempMonitor.performStart();
            trace("Set ok\n");
      
            // Register a monitor listener with the gauge monitor,
            // enabling the client to receive monitor events emitted by the
            // gauge monitor. 
            //
            trace(">>> ADD a monitor listener to the gauge monitor,");
            trace("enabling the client to receive monitor events.");
            tempMonitor.addMonitorListenerMO(listen);
            trace("Add ok\n");

            // Wait before cleaning up and terminate
            // 
            trace("Let the example run for a few minutes, giving the");
            trace("Weather m-bean time to change its property values");
            trace("to enable the gauge monitor to emit events.");
            trace("Press <Enter> to clean up and terminate...");
            System.in.read();

            // Remove the listener from the from gauge monitor m-bean.
            //
            trace(">>> REMOVE the monitor listener from the gauge monitor.");
            tempMonitor.removeMonitorListenerMO(listen);
            trace("Removal ok\n");

            // Deletes an instance of gauge monitor in the 
            // remote agent.
            //
            trace(">>> DELETE an instance of a gauge monitor in the remote agent,");
            trace("OBJECT NAME = " + tempMonitorName);
            adaptor.deleteMO(tempMonitorName);
            trace("Deletion ok\n");

            // Deletes an instance of Weather in the 
            // remote object server.
            //
            trace(">>> DELETE an instance of an m-bean in the remote agent,");
            trace("OBJECT NAME = " + weatherName);
            adaptor.deleteMO(weatherName);
            trace("Deletion ok\n");
      
            // Terminate communication with the remote agent.
            //
            adaptor.disconnect();
            return 0;
        }
        catch(Exception e) {
            trace("Got an exception !");
            e.printStackTrace();
            return 1;
        }
    }
  
    /**
     * Display trace messages.
     */
    private void trace(String msg) {
        System.out.println(msg);
    }
}
