// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)MbeanCreator.java 3.3 99/03/12 SMI"

import java.net.* ;
import java.util.* ;
import com.sun.jaw.reference.common.* ;
import com.sun.jaw.impl.adaptor.rmi.* ;

/**
 * The MbeanCreator implements a simple management application.
 * The example instantiates 30 m-beans in a remote agent and remove them again.
 * This client works in conjunction with the Client manager.
 *
 * Prior to starting the client application, make sure an agent is running.
 *
 * @version     3.3     03/12/99 
 * @author      Sun Microsystems, Inc
 *
 * @see MbeanCreator
 * @see com.sun.jaw.impl.adaptor.rmi.AdaptorClient
 * @see com.sun.jaw.impl.base.Main
 */

public class MbeanCreator implements Runnable {

    // CONSTRUCTOR
    //------------
    public MbeanCreator() {
    }

    /**
     * It is possible to specify on the command line the implementation to use
     * for the adaptor function. 
     */
    public static void main(String argv[]) {
	
        System.exit( new MbeanCreator().execute(argv) ) ;	
    }
  
    /**
     * When an object implementing interface Runnable is used to create a thread, 
     * starting the thread causes the object's run method to be called in that
     * separately executing thread.
     */
    public void run() {
	
        String[] s = new String[0];
        execute(s);
    }
  
  
    // PRIVATE METHODS
    //----------------
    private int execute(String argv[]) {
    
        try {
            // Set the host name of the remote object server.
            //
            String agentHost = InetAddress.getLocalHost().getHostName();
            if (argv.length >= 1) {
                agentHost = argv[0];
            }

            // Set the port number of the remote host.
            //
            int agentPort = 1099;
            if (argv.length >= 2) {
                agentPort = Integer.decode(argv[1]).intValue();
            }
          
            // Create an adaptor client to enable the client to manage the remote agent
            // and initializes the communications with the remote agent.
            //
            trace(">>> CREATE and INITIALIZE communication with the remote agent,");
            trace("HOST     = " + agentHost);
            trace("PORT     = " + agentPort);
            trace("PROTOCOL = RMI");
            trace("SERVER   = " + ServiceName.APT_RMI);
            AdaptorClient adaptor = new AdaptorClient();
            adaptor.connect(null, agentHost, agentPort, ServiceName.APT_RMI);
            trace("Communication ok\n");

            // Get the domain name from the remote agent.
            //
            String domain = adaptor.getDomain();
      
            // Creates 30 instances of the Simple m-bean in the
            // remote agent.
            // 
            trace(">>> CREATE 30 instances of the Simple m-bean in the remote agent.\n");
            trace("Press <Enter> to start the creation...");
            System.in.read();
            Vector objNameVec = new Vector();
            String simpleClass = "Simple";
            for (int count = 0; count < 30; count++) {
                ObjectName simpleName = new ObjectName(domain + ":SimpleMO.Creator=" + count);
                trace(">>> CREATE an instance of an m-bean in the remote agent,");
                trace("M-BEAN      =" + simpleClass);
                trace("OBJECT NAME = " + simpleName);
                adaptor.cb_newMO(simpleClass, simpleName, null);
                objNameVec.addElement(simpleName);
                trace("Creation ok\n");
        
                // Wait a few seconds for the monitors to update.
                // Note:
                //      It is especially important when using counter monitors
                //      to take into account the granularity period, as they
                //      only check for propertie values EQUAL to a certain
                //      comparison level value.
                //      If the comparison level has been passed before the
                //      Counter monitor updates it will never emmit an event or
                //      update the offset and will be as good as non-functional.
                //
                trace("Wait 1 Seconds...\n");
                Thread.sleep(1000);
            }  

            // Deletes 30 instances of the Simple m-bean in the
            // remote object server.
            //
            trace(">>> DELETE 30 instances of the Simple m-bean from the remote agent.\n");
            trace("Press <Enter> to start the deletion...");
            System.in.read();
            for (Enumeration enum = objNameVec.elements() ; enum.hasMoreElements() ; ) {
                ObjectName remObj = (ObjectName) enum.nextElement();
                trace(">>> DELETE an instance of an m-bean in the remote agent,");
                trace("OBJECT NAME = " + remObj);
                adaptor.deleteMO(remObj);
                trace("Deletion ok\n");

                // Wait a few seconds for the monitors to update.
                //        
                trace("Wait 1 Seconds...\n");
                Thread.sleep(1000);
            }

            // Terminate communication with the remote agent.
            //
            adaptor.disconnect();
            return 0;
        } catch(Exception e) {
            System.out.println("Got an exception !");
            e.printStackTrace();
            return 1;
        }
    }
  
    /**
     * Display trace messages.
     */
    private void trace(String msg) {
        System.out.println(msg);
    }
}
