// Copyright (c) 03/24/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)AskMe.java 3.4 99/03/24 SMI"

import java.util.Vector;
import java.lang.reflect.*;
import com.sun.jaw.reference.common.*;
import com.sun.jaw.reference.agent.cmf.Framework;

/**
 * A simple definition of an m-bean.
 * The m-bean shows how to:
 *      - use the initCmf method to register the m-bean
 *
 * The object has two properties:
 *      - "NbObjects" a read only property showing the number of objects in the agent
 *      - "FreeMem" a read only property showing the amount of bytes free in the VM
 */

public class AskMe implements java.io.Serializable {

    /**
     * Getter for the "NbObjects" property. The method
     * is compliant with the Bean design pattern.
     *
     * @return the current value of the "NbObjects" property.
     */
    public Integer getNbObjects() {
        try {
            Vector cnt = cmf.getObject(new ObjectName(":"), null);
            return new Integer(cnt.size());
        } catch (Exception e) {
            return new Integer(-1);
        }
    }

    /**
     * Getter for the "FreeMem" property. The method
     * is compliant with the Bean design pattern.
     *
     * @return the current value of the "FreeMem" property.
     */
    public Integer getFreeMem() {
        Runtime rt = Runtime.getRuntime();

        // Convert the amount of free memory to an Integer.
        // 
        return new Integer((int)rt.freeMemory());
    }

    /**
     * Registers the m-bean  and keep a reference to the core framework.
     *
     * @param     agent  a reference to the core management framework.
     * @param     name  the object name to use for registering.
     *
     * @exception java.lang.IllegalAccessException 
     *            The method cannot access the class definition of the specified m-bean.
     * @exception com.sun.jaw.reference.common.ServiceNotFoundException
     *            The requested service is not supported.
     * @exception com.sun.jaw.reference.common.InstanceAlreadyExistException 
     *            The m-bean is already registered in the repository.
     */
    public void initCmf(Framework agent, ObjectName name, boolean db, ModificationList list)
        throws InstanceAlreadyExistException {

        // Creates an ObjectName if it was not given.
        // NOTE:
        //      The ObjectName can be null if the request was made
        //      throught the M-Let service.
        //
        if (name == null)
            name = new ObjectName(agent.getDomain(),this.getClass().getName());

        // Keep a reference to the core management framework.
        //
        cmf = agent;

        // Register the m-bean.
        //
        if (db) {
            agent.addDBObject(this, name);
        } else {
    	    agent.addObject(this, name);
        }
    }

    // Private variables.
    //
    private Framework cmf = null;
}
