// Copyright (c) 03/24/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)Master.java 3.4 99/03/24 SMI"

import java.net.URL;
import java.util.Vector;
import com.sun.jaw.reference.common.*;
import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.impl.agent.services.mlet.*;
import java.lang.reflect.*;

/**
 * A simple definition of an m-bean.
 * The m-bean shows how to:
 *      - use the initCmf method to register the m-bean and add two new Sub m-beans
 *      - use the deleteCmf method to remove the two Sub m-beans
 *
 * The object has two properties:
 *      - "StateA" a read only property showing the status of Sub m-bean A
 *      - "StateB" a read only property showing the status of Sub m-bean B
 */

public class Master implements java.io.Serializable {

    /**
     * Getter for the "StateA" property. The method
     * is compliant with the Bean design pattern.
     *
     * @return the current value of the "State" property.
     */
    public String getStateA() {
        if (subA != null)
            stateA = subA.getState();
        return stateA;
    }

    /** 
     * Getter for the "StateB" property. The method 
     * is compliant with the Bean design pattern. 
     * 
     * @return the current value of the "State" property. 
     */ 
    public String getStateB() {
        if (subB != null)
            stateB = subB.getState();
        return stateB; 
    }

    /**
     * Register the m-bean and instanciate and register two instances of the Sub m-bean
     * using two different methods.
     *
     * @param     agent  a reference to the core management framework.
     * @param     name  the object name to use for registering.
     *
     * @exception java.lang.IllegalAccessException
     *            The method cannot access the class definition of the specified m-bean.
     * @exception com.sun.jaw.reference.common.ServiceNotFoundException
     *            The requested service is not supported.
     * @exception com.sun.jaw.reference.common.InstanceAlreadyExistException
     *            The m-bean is already registered in the repository.
     * @exception java.lang.ClassNotFoundException
     *            The class loader could not find the class to be instantiated.
     * @exception java.lang.InstantiationException
     *            A new instance of the specified class could not be created.
     * @exception java.lang.reflect.InvocationTargetException
     *            he initialization method (initCmf) of the specified class could not be executed.
     */
    public void initCmf(Framework agent, ObjectName name, boolean db, ModificationList list)
        throws InstanceAlreadyExistException, InstantiationException,
               InvocationTargetException, ClassNotFoundException,
               IllegalAccessException {

        // Creates an ObjectName if it was not given.
        // NOTE:
        //      The ObjectName can be null if the request was made
        //      throught the M-Let service.
        //
        if (name == null)
            name = new ObjectName(agent.getDomain(),this.getClass().getName());

        // Adds a named m-bean under the control of the core management framework.
        //
        agent.addObject(this, name);

        // Keep a reference of the agent.
        //
        cmf = agent;

        // Instanciate and register an instance of the Sub m-bean in the agent.
        // NOTE:
        //      By adding the m-bean in this way to the core management framework,
        //      the initCmf() method WILL NOT be called.
        //
        subNameA = new ObjectName(cmf.getDomain() + ":Sub.id=A");
        subA = new Sub();
        cmf.addObject(subA,subNameA);

        // Instanciate and register an instance of the Sub m-bean in the agent.
        // NOTE:
        //      By adding the m-bean in this way to the core management framework,
        //      the initCmf() method WILL be called.
        //
        // Retrieve the codebase of the MLetClassLoader in use.
        //
        String codebase = ((MLetClassLoader)this.getClass().getClassLoader()).getCodeBase().toString();
        // Instantiation and register a new m-bean in the agent.
        //
        subNameB = new ObjectName(cmf.getDomain() + ":Sub.id=B");
        subB = (Sub)cmf.newObject("Sub", subNameB , new ObjectName(cmf.getDomain() + ":" + ServiceName.MLETLOADER + ".codebase=" + codebase), null);
    }

    /**
     * Perform closedown tasks. Remove the two instances of the Sub m-bean from the agent.
     */
    public void deleteCmf() {
        try {
            // Remove the two Sub m-bean instances and set the reference to the agent to null.
            //
            if (subA != null)
                cmf.delObject(subNameA);
            if (subB != null)
                cmf.delObject(subNameB);
            cmf = null;
        } catch (Exception e) {
            System.out.println("Master: Got an exception !");
            e.printStackTrace();
        }
    }


    // M-bean properties.
    //
    String stateA = "Creation Failed";
    String stateB = "Creation Failed";

    // Private variables.
    //
    private ObjectName subNameA = null;
    private ObjectName subNameB = null;
    private Sub subA = null;
    private Sub subB = null;
    private Framework cmf = null;
}
