// Copyright (c) 03/23/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)Client.java 3.5 99/03/23 SMI"

import java.util.*;
import java.io.*;
import java.net.*;

// jaw import
//
import com.sun.jaw.reference.common.*;
import com.sun.jaw.reference.query.*;
import com.sun.jaw.impl.adaptor.rmi.*;
import com.sun.jaw.reference.client.mo.*;
import com.sun.jaw.impl.agent.services.mlet.*;

/**
 * The Client implements a simple management application.
 * The example shows how the M-Let service can be used to obtain m-beans
 * remotely and instanciate them in a remote agent using MLET tags in a file.
 * The following MLET tag is specified in the file:
 * 
 * <MLET
 *      CODE = Master.class
 *      ARCHIVE = Master.jar
 *      NAME = defaultDomain:Master.id=auto
 *      VERSION = 1.0
 * >
 * </MLET>
 * 
 * Note that we only specify the Master m-bean in the MLET tag, although the
 * JAR file also contains the Sub m-bean. In this case only the Master m-bean
 * will be instanciated and registered with the framework through the M-Let service. 
 * In the initCmf method of the Master m-bean we add 2 instances of the 
 * Sub m-bean to the framework.
 *
 * Prior to starting the client application, make sure an agent is running
 * with the M-Let service.
 *
 * @version     3.5     03/23/99
 * @author      Sun Microsystems, Inc
 *
 * @see Master
 * @see Sub
 * @see com.sun.jaw.reference.client.adaptor.AdaptorMO
 * @see com.sun.jaw.impl.base.Main
 */
public class Client implements Runnable {
  
    // CONSTRUCTOR
    //------------
    public Client() {
    }
  
    /**
     * You have to specify the URL pointing to the file with the MLET tags
     * on your commad line. 
     */
    public static void main(String argv[]) {
	
        System.exit( new Client().execute(argv) ) ;	
    }
  
    /**
     * When an object implementing interface Runnable is used to create a thread, 
     * starting the thread causes the object's run method to be called in that
     * separately executing thread.
     */
    public void run() {
	
        String[] s = new String[0];
        execute(s);
    }
  
  
    // PRIVATE METHODS
    //----------------
    private int execute(String argv[]) {
	
        try {      
            // Get command line arguments.
            //
            if (!parseArgs(argv)) {
                return 1;
            }
            
            // Set the host name of the remote object server.
            //
            String agentHost = InetAddress.getLocalHost().getHostName();
 
            // Set the port number of the remote host.
            //
            int agentPort = 1099;
 
            // Create an adaptor client to enable the client to manage the remote agent
            // and initializes the communications with the remote agent.
            //
            trace(">>> CREATE and INITIALIZE communication with the remote agent,");
            trace("HOST     = " + agentHost);
            trace("PORT     = " + agentPort);
            trace("PROTOCOL = RMI");
            trace("SERVER   = " + ServiceName.APT_RMI);
            AdaptorClient adaptor = new AdaptorClient();
            adaptor.connect(null, agentHost, agentPort, ServiceName.APT_RMI);
            trace("Communication ok\n");
         
            // Get the domain name from the remote agent.
            //
            String domain = adaptor.getDomain();

            // Retreive an instance of the M-Let service from the remote agent.
            // If it doesn't exist, we create it in the remote agent.
            //
            MLetSrvMO mlet = null;
            String objClass = "com.sun.jaw.impl.agent.services.mlet.MLetSrv";
            ObjectName objName = new ObjectName(domain + ":com.sun.jaw.impl.agent.services.mlet.MLetSrvMO");
            boolean created = false;
            try {
                trace(">>> GET an instance of the M-Let service from the remote agent,");
                trace("OBJECT NAME = " + objName);
                mlet = (MLetSrvMO) ((Vector)adaptor.getObject(objName, null)).firstElement();
                trace("Get ok\n");
            } catch (Exception e) {
                trace(">>> CREATE an instance of the M-Let service in the remote agent,");
                trace("M-BEAN      =" + objClass);
                trace("OBJECT NAME = " + objName);
                mlet = (MLetSrvMO) adaptor.cb_newMO(objClass, objName, null);
                created = true;
                trace("Creation ok\n");
            }    	
	  

            // Add Master and Sub m-beans to an agent given a URL which
            // refers to a document containing a MLET tag
            // that defines the Master m-bean.
            // NOTE: We only specify that the Master m-bean should be instanciated 
            //       and registered with the framework in the MLET tag. The other
            //       Sub m-beans will be instanciated and registered by the Master
            //       m-bean.
            //
            trace(">>> CREATE a Master m-bean in the remote agent using the M-Let service,");
            trace("URL = " + url);
            Vector mbeans = mlet.performRemoteLoadURL(url);
            trace("Creation ok\n");
	  
            // Display the result of the creation action. 
            //
            trace(">>> STEP through the vector containing one entry per MLET tag");
            trace("returned by the M-Let service,");
            for (Enumeration e = mbeans.elements() ; e.hasMoreElements() ;) {
                Object obj = e.nextElement();
                if (obj instanceof Throwable) {
                    trace("ERROR occured  = " + ((Throwable) obj).getMessage());
                } else {
                    trace("CREATED m-bean = " + ((MLet) obj).getName());
                }
            }
            trace("Step through ok\n");

            // Displays the state of the Master m-bean in the
            // remote agent and deletes it from the remote agent.
            //
            ObjectName masterName = new ObjectName(domain + ":Master.id=auto");
            Vector objVec = null;
            MasterMO master = null;
            try {
                trace(">>> GET the m-bean from the remote agent,");
                trace("OBJECT NAME = " + masterName);
                objVec = adaptor.getObject(masterName,null);
                trace("Get ok, number of m-beans = " + objVec.size() + "\n");
        
                // Take the first occurence of the Master m-bean
                // we get and display its state.
                //
                if (!objVec.isEmpty() && ((master = (MasterMO) objVec.firstElement()) != null)) {
                    // Access the properties of the Master m-bean remotely.
                    //
                    trace(">>> GET the property values for the m-bean from the remote agent,");
                    trace("OBJECT NAME = " + masterName);
                    trace("PROPERTY \"stateA\" = " + master.getStateA());
                    trace("PROPERTY \"stateB\" = " + master.getStateB());
                    trace("Get ok\n");

                    // Deletes an instance of the Master m-bean in the remote object server.
                    //
                    trace(">>> DELETE an instance of an m-bean from the remote agent,");
                    trace("OBJECT NAME = " + masterName);
                    adaptor.deleteMO(masterName);
                    trace("Deletion ok\n");
                }
            } catch(Exception e) {
                trace("Got an exception !");
                e.printStackTrace();
                return 1;
            }

            // Deletes an instance of the M-Let service from the
            // remote agent, if we created it.
            //
            if (created) {
                trace(">>> DELETE an instance of a gauge monitor in the remote agent,");
                trace("OBJECT NAME = " + objName);
                adaptor.deleteMO(objName);
                trace("Deletion ok\n");
            }

            // Terminate communication with the remote object server.
            //
            adaptor.disconnect();
            return 0;
        } catch(Exception e) {
            Debug.printException(e);
            e.printStackTrace();
            return 1;
        }
    }
  
    /**
     * Parse the command line arguments.
     */
    private boolean parseArgs(String argv[]) {
        
        if (argv.length == 0) {
            usage();
            return false;
        }
        url = argv[0];
        return true;
    }
    
    /**
     * Displays help information.
     */
    private void usage() {
        trace("Usage: java Client <URL>");
        trace("where:");
        trace("\t-URL: the URL pointing to the file with the MLET tags.");
        trace("\t      If the URL contains spaces, you have to enclose it");
        trace("\t      within double-quotes.\n");
        trace("Example using Solaris:");
        trace("\t      java Client file:/opt/SUNWconn/jaw/examples/mo/Mlet2/Master.html\n");
        trace("Example using WindowsNT:");
        trace("\t      java Client \"file:/c:/Program Files/SUNWconn/jaw/examples/mo/Mlet2/Master.html\"\n");
    }
    
    /**
     * Displays trace messages.
     */
    private void trace(String msg) {
        System.out.println(msg);
    }

    // PRIVATE VARIABLES
    //
    private String url = new String();
}
