// Copyright (c) 03/24/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)Name.java 3.4 99/03/24 SMI"

import com.sun.jaw.reference.common.ObjectName;
import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.reference.common.*;

/**
 * A simple definition of an m-bean.
 * The m-bean shows how to:
 *      - use the initCmf method to register the m-bean
 *
 * The object has only one property:
 *      - "State" a read only property
 */

public class Name implements java.io.Serializable {
  
    /**
     * Getter for the "State" property. The method
     * is compliant with the Bean design pattern.
     *
     * @return the current value of the "State" property.
     */
    public String getState() {
        return state;
    }

    /**
     * Register the m-bean with the agent and set the "State" property.
     *
     * @param     agent  a reference to the core management framework.
     * @param     name  the object name to use for registering.
     *
     * @exception java.lang.IllegalAccessException
     *            The method cannot access the class definition of the specified m-bean.
     * @exception com.sun.jaw.reference.common.ServiceNotFoundException
     *            The requested service is not supported.
     * @exception com.sun.jaw.reference.common.InstanceAlreadyExistException
     *            The m-bean is already registered in the repository.
     */
    public void initCmf(Framework agent, ObjectName name, boolean db, ModificationList list)
        throws InstanceAlreadyExistException {

        // Creates an ObjectName if it was not given.
        // NOTE:
        //      The ObjectName can be null if the request was made
        //      throught the M-Let service.
        //
        if (name == null) {
    		state = "NO MLET NAME -> NO object name given";
            name = new ObjectName(agent.getDomain() + ":" + this.getClass().getName() + ".id=NONAME");
        }

        // Adds a named m-bean under the control of the core management framework.
        //
        if (db) {
            agent.addDBObject(this, name);
        } else {
    	    agent.addObject(this, name);
        }
    }
  

    // M-bean properties.
    //
    private String state = "MLET NAME OK -> Object name given";
}
