// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)Simple.java 3.4 99/03/12 SMI"

/**
 * A simple definition of an m-bean.
 * The m-bean shows how to:
 *      - use indexed properties
 *
 * The object has three properties:
 *      - "State" a read/write property
 *      - "NbChanges" a read only property
 *      - "AnArray" a read/write indexed property
 */

public class Simple implements java.io.Serializable {

    public Simple() {
        // Initialize the array.
        //
        for(int i=0; i < anArray.length; i++) {
            anArray[i]= new String("Element " + i);
        }
    }

    /**
     * Getter for the "State" property. The method
     * is compliant with the Bean design pattern.
     *
     * @return the current value of the "State" property.
     */
    public String getState() {
        return state;
    }

    /**
     * Setter for the "State" property. The method is
     * compliant with the Bean design pattern.
     *
     * @param <VAR>s</VAR> the new value of the property.
     */
    public void setState(String s) {
        state = s;
        nbChanges++;
    }

    /**
     * Getter for the "NbChanges" property.The method
     * is compliant with the Bean design pattern.
     *
     * @return the current value of the "NbChanges" property.
     */
    public Integer getNbChanges() {
        return new Integer(nbChanges);
    }
  
    /**
     * Getter for the "AnArray" property.The method
     * is compliant with the Bean design pattern.
     * This method retrieves the whole array.
     *
     * @return the current value of the "AnArray" property.
     */
    public String[] getAnArray() {
        return anArray;
    }
  
    /**
     * Getter for the "AnArray" property.The method
     * is compliant with the Bean design pattern.
     * This method retrieves a specific element in the array.
     * 
     * @param <VAR>pos</VAR> index of the element to retrieve.
     * @return element pos of the "AnArray" property.
     */
    public String getAnArray(int pos) {
        //System.out.println("Simple: Get element -> " + pos);
        return anArray[pos];
    }

    /**
     * Setter for the "AnArray" property. The method is
     * compliant with the Bean design pattern.
     * This method sets a specific element in the array.
     *
     * @param <VAR>pos</VAR> index of the element to set.
     * @param <VAR>s</VAR> the new value of the property.
     */
    public void setAnArray(int pos, String elmt) {
        //System.out.println("Simple: Set element -> " + pos + " to = " + elmt);
        anArray[pos]= elmt;
    }

    /**
     * Setter for the "AnArray" property. The method is
     * compliant with the Bean design pattern.
     * This method sets the whole array.
     *
     * @param <VAR>array</VAR> the new value of the property.
     */
    public void setAnArray(String[] array ) {
        //System.out.println("Simple: Set the whole array");
        anArray= array;
    }

    // Private variables.
    //
    private int nbElement = 15;

    // M-bean properties.
    //
    private String	state = "Construct";
    private int		nbChanges = 0;
    private String[] 	anArray = new String[nbElement];
}
