// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)SerializationOutputStream.java 3.4 99/03/12 SMI"

// Java imports.
//
import java.lang.*;
import java.io.*;
import java.util.*;

// Jaw imports.
//
import com.sun.jaw.reference.common.*;
import com.sun.jaw.reference.agent.cmf.*;

/**
 * This subclass of ObjectOutputStream implements the replaceObject 
 * method to allow objects to be replaced with an alternate object.
 * All the instances of Framework will be replaced by 
 * an instance of SerializationMarker.
 *
 * @version     3.4     03/12/99
 * @author      Sun Microsystems, Inc
 *
 * @see SerializationMarker
 */


public class SerializationOutputStream extends ObjectOutputStream {

    /**
     * Create an SerializationOutputStream that writes to the 
     * specified OutputStream using object replacement.
     *
     * @exception IOException Any exception thrown by the underlying OutputStream.
     */
    public SerializationOutputStream(OutputStream outputStream)
        throws IOException {

        super(outputStream);
        // Enable the stream to do replacement of objects in the stream.
        //
        try {
            super.enableReplaceObject(true);
        } catch (SecurityException ee) {
            // Report error ...
            System.err.println("Object replacement disabled !!");
            Debug.printException(ee);
        }
        Debug.println("Object replacement enabled !!");
    }

    /**
     * This method mark the position of the Framework with a 
     * SerializationMarker object.
     * The SerializationInputStream looks for this marker 
     * and replaces it with the appropriate Framework reference.
     *   
     * @exception IOException Any exception thrown by the underlying
     * OutputStream.
     */
    protected Object replaceObject(Object object)
        throws IOException {
        // Mark all instances of Framework with a marker object.
        //
        if (object instanceof Framework) {
            return this.mark;
        }
        return object;
    }

    /* The SerializationMarker used to replace the Framework. */
    private SerializationMarker mark = new SerializationMarker();
}
