// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)SerializationConvertion.java 3.3 99/03/12 SMI"

import java.io.*;
import java.lang.*;
import com.sun.jaw.reference.agent.cmf.*;

/**
 * This class is responsible for the serialization and 
 * deserialization of objects from and to byte arrays.
 *
 * @version     3.3     03/12/99
 * @author      Sun Microsystems, Inc
 * 
 * @see java.io.Serializable
 * @see SerializationInputStream
 * @see SerializationOutputStream
 */


public class SerializationConvertion  {

    /**
     * Default constructor.
     */
    public SerializationConvertion() {
        super();
    }

    /**
     * Serialize the object to an array of bytes.
     *
     * @exception IllegalArgumentException Unable to convert the object 
     *            to an array of bytes.
     */
    public byte[] toBytes(Object object)
        throws IllegalArgumentException {
    
        if (!(object instanceof Serializable)) {
            throw new IllegalArgumentException("Invalid object !! Object must be serializable.");
        }

        ByteArrayOutputStream baos = null;
        byte[] buffer = null;
        try {
            baos = new ByteArrayOutputStream();
            SerializationOutputStream oos = new SerializationOutputStream(baos);
            oos.writeObject(object);
            oos.flush();
            buffer = baos.toByteArray();
        } catch(IOException ee) {
            throw new IllegalArgumentException(ee.getClass().getName() + ": " + ee.getMessage());
        } finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            } catch(IOException ex) {
                // Ignore ...
            }
        }
        return buffer;
    }

    /**
     * Deserialize an object from an array of object bytes.
     *
     * @exception IllegalArgumentException Unable to recostruct the object 
     *            from the array of bytes.
     */
    public Object fromBytes(byte[] buffer)
        throws IllegalArgumentException {
    
        Object object = null;
        ByteArrayInputStream bais = null;

        try {
            bais = new ByteArrayInputStream(buffer);
            SerializationInputStream osis = new SerializationInputStream(bais, cmf);
            object = osis.readObject();
        } catch(IOException ee) {
            throw new IllegalArgumentException(ee.getClass().getName() + ": " + ee.getMessage());
        } catch(ClassNotFoundException ee) {
            throw new IllegalArgumentException(ee.getClass().getName() + ": " + ee.getMessage());
        } finally {
            try {
                if (bais != null) {
                    bais.close();
                }
            } catch(IOException ex) {
                // Ignore ...
            }
        }
        return object;
    }

    /**
     * Set the Framework reference.
     */
    public void setFramework(Framework cmf) {
        this.cmf = cmf;
    }

    /* Reference to the Framework. */
    private transient Framework cmf = null;
}
