// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)Client.java 3.3 99/03/12 SMI"

import java.util.*;
import java.net.*;

// jaw import
//
import com.sun.jaw.reference.common.*;
import com.sun.jaw.reference.query.*;
import com.sun.jaw.reference.client.adaptor.*;
import com.sun.jaw.reference.client.mo.*;

/**
 * This class provides a simple example showing how to write a client.
 *
 * @version     3.3     03/12/99
 * @author      Sun Microsystems, Inc
 */


public class Client implements Runnable {
  
    // CONSTRUCTOR
    //------------

    public Client() {
        super();
    }


    // PUBLIC METHODS
    //---------------

    /**
     * Create an adaptor client to enable the client to manage an agent.
     *
     * @param <VAR>adaptor</VAR> Name of the adaptor client to be created.
     *
     * @exception ClassNotFoundException The specified class could not be found.
     * @exception InstantiationException A new instance of the specified class could not be created.
     * @exception IllegalAccessException The method has tried to access a class that is not public and in another package.
     */
    public Client(String adaptor) throws
    ClassNotFoundException, InstantiationException, IllegalAccessException {

        trace("CREATE an adaptor client,");
        trace("PROTOCOL = " + adaptor);
        trace("enabling the client to manage an agent.\n");
	
        // Get the implementation requested for the adaptor.
        //
        Class factoryClass = Class.forName(adaptor);
	
        // Create the adaptor stub.
        //
        MOFactory = (AdaptorMO)factoryClass.newInstance();
    }
    

    public static void main(String args[]) {
	
        System.exit( new Client().execute(args) ) ;	
    }
    
  
    /**
     * When an object implementing interface Runnable is used to create a thread, 
     * starting the thread causes the object's run method to be called in that
     * separately executing thread.
     */
    public void run() {
	
        String[] s = new String[0];
        execute(s);
    }
  
  
    // GETTERS AND SETTERS
    //--------------------
    /**
     * Returns the version of this class.
     */
    public String getClassVersion() {
        return (sccs_id);
    }
  
  
    // PRIVATE METHODS
    //----------------
    private int execute(String args[]) {
	
        // Get the properties indicating the implementation to use
        // for the adaptor.
        // In theory, this information should be obtained from a directory
        // service. The client will give the server name it wishes to contact
        // and automagically will get the adaptor name to use as well as port
        // and logical name.
        //
        Properties p = System.getProperties();
        String protocol;
        if ((protocol = System.getProperty("ADAPTOR")) == null) {
            protocol = defaultClient;
        }
      
        String host;
        if ((host = System.getProperty("HOST")) == null) {
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch(Exception e) {
                Debug.printException(e);
                usage();
                //System.exit(1);
                return 1;
            }
        }

        String logicalName;
        if ((logicalName = System.getProperty("NAME")) == null) {
            logicalName = defaultName;
        }

        String portName;
        int port;
        if ((portName = System.getProperty("PORT")) == null) {
            port = defaultPort;
        } else {
            port = Integer.parseInt(portName);
        }

        // Try to create a client and its associated MO Adaptor.
        //
        Client aClient = null;
        try {
            aClient = new Client(protocol);
        }
        catch (Exception e) {
            Debug.printException(e);
            return 1;
        }
      
        // Connect the MOFactory of the client to the server.
        //
        trace("INITIALIZE communication with the agent,");
        trace("HOST     = " + host);
        trace("PORT     = " + port);
        trace("SERVER   = " + logicalName + "\n");
        try {
            aClient.MOFactory.connect(null, host, port, logicalName);

            // Get the domain name of the server.
            //
            String domain = aClient.MOFactory.getDomain();
            trace("GET the domain name of the agent,\nDOMAIN   = " + domain + "\n");

            // Now try to create a remote object.
            //
            String className = new String("Simple");
            ObjectName newName = new ObjectName(domain + ":" + className + "MO");
            trace("CREATE an instance of the \nM-BEAN   = " + className + "\nin the agent, whith the \nOBJECT NAME = " + newName);
            SimpleMO newMoi = (SimpleMO) aClient.MOFactory.cb_newMO(className, newName, null);
            trace("Creation ok !\n");
          
            // Get the values for the properties of the remote m-bean.
            //
            trace("GET the property values of the remote m-bean,");
            trace("State     = " + newMoi.getState());
            trace("NbChanges = " + newMoi.getNbChanges() + "\n");
          
            // Set the value for the "state" property of the remote m-bean.
            //
            trace("SET the value for the \"state\" property of the remote m-bean,");
            String val = "Why not ?";
            trace("State     = " + val + "\n");
            newMoi.setState(val);
          
            // Get the new values for the properties of the remote m-bean.
            //
            trace("GET the new property values of the remote m-bean,");
            trace("State     = " + newMoi.getState());
            trace("NbChanges = " + newMoi.getNbChanges() + "\n");
          
            // Delete the remote m-bean.
            //
            trace("DELETE the m-bean from the agent.");
            newMoi.deleteObject();
            trace("Deletion ok !\n");
        }
        catch(Exception e) {
            Debug.printException(e);
            e.printStackTrace();
            return 1;
        }
        //System.exit(0);
        return 0;
    }
  
    private void usage() {
        trace("java -DADAPTOR=\"adaptor\" -DHOST=\"hostname\" -DPORT=\"port\" -NAME=\"name\n Client");
        trace("where\n\tadaptor is class name of the client adaptor");
        trace("\thostname is name of the server");
        trace("\tport is port number to use");
        trace("\name is logical name of server to use");
    }

    // PRIVATE METHODS
    //----------------

    /**
     * Display trace messages.
     */
    private void trace(String msg) {
        System.out.println(msg);
    }
  
    // PRIVATE VARIABLES
    //------------------

    /**
     * Version of the implementation.
     */
    private static final String sccs_id = "@(#)Client.java 3.3 03/12/99 SMI";

    /**
     * By default if no class name is specified on the command line, then the client
     * will use the RMI-based adaptor.
     */
    private static final String defaultClient = "com.sun.jaw.impl.adaptor.rmi.AdaptorClient";

    /**
     * Default port number if nothing is specified.
     */
    private static int defaultPort = 1099;

    /**
     * Default logical name for server.
     */
    private static String defaultName = "com.sun.jaw.impl.adaptor.rmi.AdaptorServer";

    /**
     * MO Adaptor associated to a client instance.
     */
    private AdaptorMO MOFactory = null;
}
