// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)Client.java 3.3 99/03/12 SMI"

import java.util.*;
import java.net.*;

// jaw import
//
import com.sun.jaw.reference.common.*;
import com.sun.jaw.reference.query.*;
import com.sun.jaw.reference.client.adaptor.*;
import com.sun.jaw.reference.client.mo.*;

/**
 * This class provides a simple example showing how to write a client
 * using the Java Dynamic Management framework and IIOP adaptor.
 *
 * @version     3.3     03/12/99
 * @author      Sun Microsystems, Inc
 *
 */


public class Client implements Runnable {

    // CONSTRUCTOR
    //------------
    public Client() {
    }
  
    /**
     * @exception ClassNotFoundException The specified class could not be found.
     * @exception InstantiationException A new instance of the specified class could not be created.
     * @exception IllegalAccessException The method has tried to access a class that is not public and in another package.
     */
    public Client(String adaptor) throws
    ClassNotFoundException, InstantiationException, IllegalAccessException {
	
        // ------------
        // Get the implementation requested for the adaptor.
        // ------------
        Class factoryClass = Class.forName(adaptor);
	
        // ------------
        // Create the adaptor stub.
        // ------------
        MOFactory = (AdaptorMO) factoryClass.newInstance();
    }	

    public static void main(String args[]) {
	
        System.exit( new Client().execute(args) ) ;	
    }

    /**
     * When an object implementing interface Runnable is used to create a thread, 
     * starting the thread causes the object's run method to be called in that
     * separately executing thread.
     */
    public void run() {
	
        String[] s = new String[0];
        execute(s);
    }
  
  
    // GETTERS AND SETTERS
    //--------------------
    /**
     * Returns the version of this class.
     */
    public String getClassVersion() {
        return (sccs_id);
    }


    // PRIVATE METHODS
    //----------------
    private int execute(String args[]) {
	
        // ------------
        // Debugging option.
        // ------------
        Debug.setOn(Debug.EXCPT_DEBUG);
        Debug.setOn(Debug.ADP_DEBUG);

        // ------------
        // Get the properties indicating the implementation to use
        // for the adaptor.
        // ------------
        Properties p = System.getProperties();
      
        // ------------
        // Corba naming service Host configuration.
        // ------------
        String corbaHost;
        if ((corbaHost = System.getProperty("CORBAHOST")) == null) {
            try {
                corbaHost = InetAddress.getLocalHost().getHostName();
            }
            catch(Exception e) {
                Debug.printException(e);
                usage();
                //System.exit(1);
                return 1;
            }
        }
	
        // ------------
        // Corba naming service Port configuration.
        // ------------
        String portName;
        int corbaPort = defaultCorbaPort ;
        if ((portName = System.getProperty("CORBAPORT")) != null) {
            try {
                corbaPort = Integer.parseInt(portName);
            }
            catch(Exception e) {
                Debug.printException(e);
                usage();
                //System.exit(1);
                return 1;
            }
        }
	
        // ------------
        // JDMK agent host configuration.
        // ------------
        String agentHost;
        if ((agentHost = System.getProperty("AGENTHOST")) == null) {
            try {
                agentHost = InetAddress.getLocalHost().getHostName();
            }
            catch(Exception e) {
                Debug.printException(e);
                usage();
                //System.exit(1);
                return 1;
            }
        }
	
        // ------------
        // IIOP name configuration.
        // ------------
        String logicalName;
        if ((logicalName = System.getProperty("NAME")) == null) {
            logicalName = defaultName;
        }

        System.err.println("\n\n--------------------------------------");
        System.err.println("Client: IIOP adaptor Initialize client with");
        System.err.println("\tCORBA NAMING SERVICE HOST= " + corbaHost);
        System.err.println("\tCORBA NAMING SERVICE PORT= " + corbaPort);
        System.err.println("\tJDMK AGENT HOST= " + agentHost);
        System.err.println("\tPORT= " + corbaPort);
        System.err.println("\tNAME= " + logicalName);

        // ------------
        // Create a client now.
        // ------------
        Client aClient = null;
        try {
            aClient = new Client("com.sun.jaw.impl.adaptor.iiop.AdaptorClient");
        }
        catch (Exception e) {
            Debug.printException(e);
            return 1;
        }
	      
        // ------------
        // Connect the MOFactory of the client to the server.
        // ------------
        try {

            // ------------
            // setup client.
            // ------------
            System.err.println("\n\n--------------------------------------");
            System.out.println("CORBA naming service configuration");
            aClient.MOFactory.setup(corbaHost + ":" + corbaPort) ;

            // ------------
            // Connection.
            // ------------
            System.err.println("\n\n--------------------------------------");
            System.out.println("Connection to remove agent");
            aClient.MOFactory.connect(null, agentHost, 0 , logicalName);

            // ------------
            // Get the domain name of the server.
            // ------------
            System.err.println("\n\n--------------------------------------");
            System.out.println("Get the domain main");
            String domain = aClient.MOFactory.getDomain();
            System.out.println("DOMAIN NAME= " + domain);
	
            // ------------
            // now try to create a remote object.
            // ------------
            System.err.println("\n\n--------------------------------------");
            System.out.println("Create NEW REMOTE OBJECT");
            String className = new String("Simple");
            ObjectName newName = new ObjectName(domain + ":" + className + "MO");
            SimpleMO newMoi = (SimpleMO) aClient.MOFactory.cb_newMO(className, newName, null);
            System.out.println("First creation ok");

            // ------------
            // Get 'state'
            // ------------
            System.out.println("\tState= " + newMoi.getState());

            // ------------
            // Set 'state' to "Why not ?"
            // ------------
            String val = "Why not ?";
            System.out.println("\tSet State= " + val);
            newMoi.setState(val);

            // ------------
            // Get 'state'
            // ------------
            System.out.println("\tState= " + newMoi.getState());
            System.out.println("\tNbChanges= " + newMoi.getNbChanges());
	
            // ------------
            // Set 'state' to "because ..."
            // ------------
            val = "because ...";
            System.out.println("\tSet State= " + val);
            newMoi.setState(val);
	
            // ------------
            // Delete Object
            // ------------
            System.err.println("\n\n--------------------------------------");
            System.out.println("Delete the object");
            newMoi.deleteObject();
            System.out.println("\tDeletion of the object is OK");
        }
        catch(Exception e) {
            Debug.printException(e);
            e.printStackTrace();
            return 1;
        }
        //System.exit(0);
        return 0;
    }
  
    private static void usage() {
        System.out.println("java -DADAPTOR=\"adaptor\" -DHOST=\"hostname\" -DPORT=\"corbaPort\" -NAME=\"name\n Client");
        System.out.println("where\n\tadaptor is class name of the client adaptor");
        System.out.println("\thostname is name of the server");
        System.out.println("\tcorbaPort is corbaPort number to use");
        System.out.println("\name is logical name of server to use");
    }
  
  
    // PRIVATE VARIABLES
    //------------------
    /**
     * Version of the implementation
     */
    private static final String sccs_id = "@(#)Client.java 3.3 99/03/12 SMI";

    /**
     * Default logical name for server
     */
    private static String defaultName = "com.sun.jaw.impl.adaptor.iiop.AdaptorServerImpl";

    /**
     * MO Adaptor associated to a client instance
     */
    private AdaptorMO MOFactory = null;

    /**
     * Default corbaPort number if nothing is specified
     */
    private static int defaultCorbaPort = 8085;
}
